/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.translation.SparkTranslationContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.joda.time.Instant;

public class SparkStreamingTranslationContext
extends SparkTranslationContext {
    private final JavaStreamingContext streamingContext;
    private final Instant firstTimestamp;

    public SparkStreamingTranslationContext(JavaSparkContext jsc, SparkPipelineOptions options, JobInfo jobInfo) {
        super(jsc, options, jobInfo);
        Duration batchDuration = new Duration(options.getBatchIntervalMillis().longValue());
        this.streamingContext = new JavaStreamingContext(jsc, batchDuration);
        this.firstTimestamp = new Instant();
    }

    public JavaStreamingContext getStreamingContext() {
        return this.streamingContext;
    }

    public Instant getFirstTimestamp() {
        return this.firstTimestamp;
    }
}

