/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.util.Collections;
import java.util.List;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.SchemaHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.ObjectType;
import scala.collection.JavaConversions;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class EncoderFactory {
    public static <T> Encoder<T> fromBeamCoder(Coder<T> coder) {
        Class clazz = coder.getEncodedTypeDescriptor().getRawType();
        ClassTag classTag = ClassTag$.MODULE$.apply(clazz);
        List<EncoderHelpers.EncodeUsingBeamCoder<T>> serializers = Collections.singletonList(new EncoderHelpers.EncodeUsingBeamCoder<T>((Expression)new BoundReference(0, (DataType)new ObjectType(clazz), true), coder));
        return new ExpressionEncoder(SchemaHelpers.binarySchema(), false, JavaConversions.collectionAsScalaIterable(serializers).toSeq(), new EncoderHelpers.DecodeUsingBeamCoder<T>((Expression)new Cast((Expression)new GetColumnByOrdinal(0, DataTypes.BinaryType), DataTypes.BinaryType), classTag, coder), classTag);
    }
}

