/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.streaming;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.PipelineTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TranslationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.streaming.ReadSourceTranslatorStreaming;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PipelineTranslatorStreaming
extends PipelineTranslator {
    private static final Map<Class<? extends PTransform>, TransformTranslator> TRANSFORM_TRANSLATORS = new HashMap<Class<? extends PTransform>, TransformTranslator>();

    public PipelineTranslatorStreaming(SparkStructuredStreamingPipelineOptions options) {
        this.translationContext = new TranslationContext(options);
    }

    @Override
    protected TransformTranslator<?> getTransformTranslator(TransformHierarchy.Node node) {
        @Nullable PTransform transform = node.getTransform();
        if (transform == null) {
            return null;
        }
        return TRANSFORM_TRANSLATORS.get(transform.getClass());
    }

    static {
        TRANSFORM_TRANSLATORS.put(SplittableParDo.PrimitiveUnboundedRead.class, new ReadSourceTranslatorStreaming());
    }
}

