/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.runners.spark.structuredstreaming.translation.SchemaHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.CoderHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.ObjectType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import scala.StringContext;
import scala.collection.JavaConversions;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class EncoderHelpers {
    public static <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> fromBeamCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        Class clazz = coder.getEncodedTypeDescriptor().getRawType();
        ClassTag classTag = ClassTag$.MODULE$.apply(clazz);
        List<EncodeUsingBeamCoder<T>> serializers = Collections.singletonList(new EncodeUsingBeamCoder<T>((Expression)new BoundReference(0, (DataType)new ObjectType(clazz), true), coder));
        return new ExpressionEncoder(SchemaHelpers.binarySchema(), false, JavaConversions.collectionAsScalaIterable(serializers).toSeq(), new DecodeUsingBeamCoder<T>((Expression)new Cast((Expression)new GetColumnByOrdinal(0, DataTypes.BinaryType), DataTypes.BinaryType), classTag, coder), classTag);
    }

    public static class DecodeUsingBeamCoder<@UnknownKeyFor T>
    extends UnaryExpression
    implements NonSQLExpression,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized Expression child;
        private final @UnknownKeyFor @NonNull @Initialized ClassTag<T> classTag;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        public DecodeUsingBeamCoder(@UnknownKeyFor @NonNull @Initialized Expression child, @UnknownKeyFor @NonNull @Initialized ClassTag<T> classTag, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.child = child;
            this.classTag = classTag;
            this.coder = coder;
        }

        public @UnknownKeyFor @NonNull @Initialized Expression child() {
            return this.child;
        }

        public @UnknownKeyFor @NonNull @Initialized ExprCode doGenCode(@UnknownKeyFor @NonNull @Initialized CodegenContext ctx, @UnknownKeyFor @NonNull @Initialized ExprCode ev) {
            String accessCode = ctx.addReferenceObj("coder", this.coder, this.coder.getClass().getName());
            ExprCode input = this.child.genCode(ctx);
            String javaType = CodeGenerator.javaType((DataType)this.dataType());
            ArrayList<String> parts = new ArrayList<String>();
            ArrayList<String> args = new ArrayList<String>();
            parts.add("final ");
            args.add(javaType);
            parts.add(" ");
            args.add((String)ev.value());
            parts.add(" = (");
            args.add(javaType);
            parts.add(") org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers.DecodeUsingBeamCoder.decode(");
            args.add((String)input.isNull());
            parts.add(", ");
            args.add((String)input.value());
            parts.add(", ");
            args.add(accessCode);
            parts.add(");");
            StringContext sc = new StringContext(JavaConversions.collectionAsScalaIterable(parts).toSeq());
            Block code = new Block.BlockHelper(sc).code(JavaConversions.collectionAsScalaIterable(args).toSeq());
            return ev.copy(input.code().$plus(code), input.isNull(), ev.value());
        }

        public @UnknownKeyFor @NonNull @Initialized DataType dataType() {
            return new ObjectType(this.classTag.runtimeClass());
        }

        public @UnknownKeyFor @NonNull @Initialized Object productElement(@UnknownKeyFor @NonNull @Initialized int n) {
            switch (n) {
                case 0: {
                    return this.child;
                }
                case 1: {
                    return this.classTag;
                }
                case 2: {
                    return this.coder;
                }
            }
            throw new ArrayIndexOutOfBoundsException("productElement out of bounds");
        }

        public @UnknownKeyFor @NonNull @Initialized int productArity() {
            return 3;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean canEqual(@UnknownKeyFor @NonNull @Initialized Object that) {
            return that instanceof DecodeUsingBeamCoder;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecodeUsingBeamCoder that = (DecodeUsingBeamCoder)o;
            return this.child.equals(that.child) && this.classTag.equals(that.classTag) && this.coder.equals(that.coder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(super.hashCode(), this.child, this.classTag, this.coder);
        }

        public static <T> T decode(@UnknownKeyFor @NonNull @Initialized boolean isNull, @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] serialized, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return isNull ? null : (T)CoderHelpers.fromByteArray(serialized, coder);
        }
    }

    public static class EncodeUsingBeamCoder<@UnknownKeyFor T>
    extends UnaryExpression
    implements NonSQLExpression,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized Expression child;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        public EncodeUsingBeamCoder(@UnknownKeyFor @NonNull @Initialized Expression child, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.child = child;
            this.coder = coder;
        }

        public @UnknownKeyFor @NonNull @Initialized Expression child() {
            return this.child;
        }

        public @UnknownKeyFor @NonNull @Initialized ExprCode doGenCode(@UnknownKeyFor @NonNull @Initialized CodegenContext ctx, @UnknownKeyFor @NonNull @Initialized ExprCode ev) {
            String accessCode = ctx.addReferenceObj("coder", this.coder, this.coder.getClass().getName());
            ExprCode input = this.child.genCode(ctx);
            String javaType = CodeGenerator.javaType((DataType)this.dataType());
            ArrayList<String> parts = new ArrayList<String>();
            ArrayList<String> args = new ArrayList<String>();
            parts.add("final ");
            args.add(javaType);
            parts.add(" ");
            args.add((String)ev.value());
            parts.add(" = org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers.EncodeUsingBeamCoder.encode(");
            args.add((String)input.isNull());
            parts.add(", ");
            args.add((String)input.value());
            parts.add(", ");
            args.add(accessCode);
            parts.add(");");
            StringContext sc = new StringContext(JavaConversions.collectionAsScalaIterable(parts).toSeq());
            Block code = new Block.BlockHelper(sc).code(JavaConversions.collectionAsScalaIterable(args).toSeq());
            return ev.copy(input.code().$plus(code), input.isNull(), ev.value());
        }

        public @UnknownKeyFor @NonNull @Initialized DataType dataType() {
            return DataTypes.BinaryType;
        }

        public @UnknownKeyFor @NonNull @Initialized Object productElement(@UnknownKeyFor @NonNull @Initialized int n) {
            switch (n) {
                case 0: {
                    return this.child;
                }
                case 1: {
                    return this.coder;
                }
            }
            throw new ArrayIndexOutOfBoundsException("productElement out of bounds");
        }

        public @UnknownKeyFor @NonNull @Initialized int productArity() {
            return 2;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean canEqual(@UnknownKeyFor @NonNull @Initialized Object that) {
            return that instanceof EncodeUsingBeamCoder;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodeUsingBeamCoder that = (EncodeUsingBeamCoder)o;
            return this.child.equals(that.child) && this.coder.equals(that.coder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(super.hashCode(), this.child, this.coder);
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encode(@UnknownKeyFor @NonNull @Initialized boolean isNull, @Nullable T value, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return isNull ? null : CoderHelpers.toByteArray(value, coder);
        }
    }
}

