/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.resources.PipelineResources;
import org.apache.beam.runners.spark.SparkCommonPipelineOptions;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface SparkPipelineOptions
extends SparkCommonPipelineOptions {
    @Description(value="Batch interval for Spark streaming in milliseconds.")
    @Default.Long(value=500L)
    public @UnknownKeyFor @NonNull @Initialized Long getBatchIntervalMillis();

    public void setBatchIntervalMillis(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="Batch default storage level")
    @Default.String(value="MEMORY_ONLY")
    public @UnknownKeyFor @NonNull @Initialized String getStorageLevel();

    public void setStorageLevel(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Minimum time to spend on read, for each micro-batch.")
    @Default.Long(value=200L)
    public @UnknownKeyFor @NonNull @Initialized Long getMinReadTimeMillis();

    public void setMinReadTimeMillis(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="Max records per micro-batch. For streaming sources only.")
    @Default.Long(value=-1L)
    public @UnknownKeyFor @NonNull @Initialized Long getMaxRecordsPerBatch();

    public void setMaxRecordsPerBatch(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="A value between 0-1 to describe the percentage of a micro-batch dedicated to reading from UnboundedSource.")
    @Default.Double(value=0.1)
    public @UnknownKeyFor @NonNull @Initialized Double getReadTimePercentage();

    public void setReadTimePercentage(@UnknownKeyFor @NonNull @Initialized Double var1);

    @Description(value="The period to checkpoint (in Millis). If not set, Spark will default to Max(slideDuration, Seconds(10)). This PipelineOptions default (-1) will end-up with the described Spark default.")
    @Default.Long(value=-1L)
    public @UnknownKeyFor @NonNull @Initialized Long getCheckpointDurationMillis();

    public void setCheckpointDurationMillis(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="If set bundleSize will be used for splitting BoundedSources, otherwise default to splitting BoundedSources on Spark defaultParallelism. Most effective when used with Spark dynamicAllocation.")
    @Default.Long(value=0L)
    public @UnknownKeyFor @NonNull @Initialized Long getBundleSize();

    @Experimental
    public void setBundleSize(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="If the spark runner will be initialized with a provided Spark Context. The Spark Context should be provided with SparkContextOptions.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean getUsesProvidedSparkContext();

    public void setUsesProvidedSparkContext(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="Disable caching of reused PCollections for whole Pipeline. It's useful when it's faster to recompute RDD rather than save. ")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean isCacheDisabled();

    public void setCacheDisabled(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized boolean isLocalSparkMaster(@UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options) {
        return options.getSparkMaster().matches("local\\[?\\d*]?");
    }

    @Internal
    public static void prepareFilesToStage(@UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options) {
        if (!SparkPipelineOptions.isLocalSparkMaster(options)) {
            List filesToStage = options.getFilesToStage().stream().map(File::new).filter(File::exists).map(file -> file.getAbsolutePath()).collect(Collectors.toList());
            options.setFilesToStage(PipelineResources.prepareFilesForStaging(filesToStage, (String)((String)MoreObjects.firstNonNull((Object)options.getTempLocation(), (Object)System.getProperty("java.io.tmpdir")))));
        }
    }
}

