/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.resources.PipelineResources;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.SparkTransformOverrides;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TranslationContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineTranslator
extends Pipeline.PipelineVisitor.Defaults {
    private @UnknownKeyFor @NonNull @Initialized int depth = 0;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PipelineTranslator.class);
    protected @UnknownKeyFor @NonNull @Initialized TranslationContext translationContext;

    public static void prepareFilesToStageForRemoteClusterExecution(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        if (!PipelineTranslator.isLocalSparkMaster(options)) {
            options.setFilesToStage(PipelineResources.prepareFilesForStaging(options.getFilesToStage(), (String)options.getTempLocation()));
        }
    }

    public static void replaceTransforms(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingOptions options) {
        pipeline.replaceAll(SparkTransformOverrides.getDefaultOverrides(options.isStreaming()));
    }

    public static void detectTranslationMode(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingOptions options) {
        TranslationModeDetector detector = new TranslationModeDetector();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)detector);
        if (detector.getTranslationMode().equals((Object)TranslationMode.STREAMING)) {
            options.setStreaming(true);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String genSpaces(@UnknownKeyFor @NonNull @Initialized int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            builder.append("|   ");
        }
        return builder.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isLocalSparkMaster(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        return options.getSparkMaster().matches("local\\[?\\d*]?");
    }

    protected abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getTransformTranslator(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var1);

    private <T extends PTransform<?, ?>> void applyTransformTranslator(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transformTranslator) {
        this.translationContext.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
        PTransform typedTransform = node.getTransform();
        TransformTranslator<?> typedTransformTranslator = transformTranslator;
        typedTransformTranslator.translateTransform(typedTransform, this.translationContext);
    }

    public void translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        LOG.debug("starting translation of the pipeline using {}", (Object)((Object)((Object)this)).getClass().getName());
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)this);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        LOG.debug("{} enterCompositeTransform- {}", (Object)PipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        ++this.depth;
        TransformTranslator<?> transformTranslator = this.getTransformTranslator(node);
        if (transformTranslator != null) {
            this.applyTransformTranslator(node, transformTranslator);
            LOG.debug("{} translated- {}", (Object)PipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
            return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
        }
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        --this.depth;
        LOG.debug("{} leaveCompositeTransform- {}", (Object)PipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        LOG.debug("{} visitPrimitiveTransform- {}", (Object)PipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        TransformTranslator<?> transformTranslator = this.getTransformTranslator(node);
        if (transformTranslator == null) {
            String transformUrn = PTransformTranslation.urnForTransform((PTransform)node.getTransform());
            throw new UnsupportedOperationException("The transform " + transformUrn + " is currently not supported.");
        }
        this.applyTransformTranslator(node, transformTranslator);
    }

    public @UnknownKeyFor @NonNull @Initialized TranslationContext getTranslationContext() {
        return this.translationContext;
    }

    private static class TranslationModeDetector
    extends Pipeline.PipelineVisitor.Defaults {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TranslationModeDetector.class);
        private @UnknownKeyFor @NonNull @Initialized TranslationMode translationMode;

        TranslationModeDetector(@UnknownKeyFor @NonNull @Initialized TranslationMode defaultMode) {
            this.translationMode = defaultMode;
        }

        TranslationModeDetector() {
            this(TranslationMode.BATCH);
        }

        @UnknownKeyFor @NonNull @Initialized TranslationMode getTranslationMode() {
            return this.translationMode;
        }

        public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
            if (this.translationMode.equals((Object)TranslationMode.BATCH) && value instanceof PCollection && ((PCollection)value).isBounded() == PCollection.IsBounded.UNBOUNDED) {
                LOG.info("Found unbounded PCollection {}. Switching to streaming execution.", (Object)value.getName());
                this.translationMode = TranslationMode.STREAMING;
            }
        }
    }

    private static enum TranslationMode {
        BATCH,
        STREAMING;

    }
}

