/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.metrics.AggregatorMetric;
import org.apache.beam.runners.spark.metrics.SparkBeamMetric;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSortedMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithMetricsSupport
extends MetricRegistry {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WithMetricsSupport.class);
    private final @UnknownKeyFor @NonNull @Initialized MetricRegistry internalMetricRegistry;

    private WithMetricsSupport(@UnknownKeyFor @NonNull @Initialized MetricRegistry internalMetricRegistry) {
        this.internalMetricRegistry = internalMetricRegistry;
    }

    public static @UnknownKeyFor @NonNull @Initialized WithMetricsSupport forRegistry(@UnknownKeyFor @NonNull @Initialized MetricRegistry metricRegistry) {
        return new WithMetricsSupport(metricRegistry);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Timer> getTimers(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return this.internalMetricRegistry.getTimers(filter);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Meter> getMeters(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return this.internalMetricRegistry.getMeters(filter);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Histogram> getHistograms(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return this.internalMetricRegistry.getHistograms(filter);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Counter> getCounters(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return this.internalMetricRegistry.getCounters(filter);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge> getGauges(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return new ImmutableSortedMap.Builder((Comparator)Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER)).putAll((Map)this.internalMetricRegistry.getGauges(filter)).putAll(this.extractGauges(this.internalMetricRegistry, filter)).build();
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge> extractGauges(@UnknownKeyFor @NonNull @Initialized MetricRegistry metricRegistry, @UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>();
        Optional aggregatorMetrics = FluentIterable.from(metricRegistry.getMetrics().entrySet()).firstMatch(this.isAggregatorMetric()).transform(this.aggregatorMetricToGauges());
        Optional beamMetrics = FluentIterable.from(metricRegistry.getMetrics().entrySet()).firstMatch(this.isSparkBeamMetric()).transform(this.beamMetricToGauges());
        if (aggregatorMetrics.isPresent()) {
            gauges.putAll(Maps.filterEntries((Map)((Map)aggregatorMetrics.get()), this.matches(filter)));
        }
        if (beamMetrics.isPresent()) {
            gauges.putAll(Maps.filterEntries((Map)((Map)beamMetrics.get()), this.matches(filter)));
        }
        return gauges;
    }

    private @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metric>, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge>> aggregatorMetricToGauges() {
        return entry -> {
            NamedAggregators agg = ((AggregatorMetric)entry.getValue()).getNamedAggregators();
            String parentName = (String)entry.getKey();
            Map gaugeMap = Maps.transformEntries(agg.renderAll(), this.toGauge());
            LinkedHashMap fullNameGaugeMap = Maps.newLinkedHashMap();
            for (Map.Entry gaugeEntry : gaugeMap.entrySet()) {
                fullNameGaugeMap.put(parentName + "." + (String)gaugeEntry.getKey(), (Gauge)gaugeEntry.getValue());
            }
            return Maps.filterValues((Map)fullNameGaugeMap, (Predicate)Predicates.notNull());
        };
    }

    private @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metric>, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge>> beamMetricToGauges() {
        return entry -> {
            Map<String, ?> metrics = ((SparkBeamMetric)entry.getValue()).renderAll();
            String parentName = (String)entry.getKey();
            Map gaugeMap = Maps.transformEntries(metrics, this.toGauge());
            LinkedHashMap fullNameGaugeMap = Maps.newLinkedHashMap();
            for (Map.Entry gaugeEntry : gaugeMap.entrySet()) {
                fullNameGaugeMap.put(parentName + "." + (String)gaugeEntry.getKey(), (Gauge)gaugeEntry.getValue());
            }
            return Maps.filterValues((Map)fullNameGaugeMap, (Predicate)Predicates.notNull());
        };
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Maps.EntryTransformer<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Gauge> toGauge() {
        return (name, rawValue) -> () -> {
            try {
                return Double.parseDouble(rawValue.toString());
            }
            catch (Exception e) {
                LOG.warn("Failed reporting metric with name [{}], of type [{}], since it could not be converted to double", new Object[]{name, rawValue.getClass().getSimpleName(), e});
                return null;
            }
        };
    }

    private @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge>> matches(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return entry -> filter.matches((String)entry.getKey(), (Metric)entry.getValue());
    }

    private @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metric>> isAggregatorMetric() {
        return metricEntry -> metricEntry.getValue() instanceof AggregatorMetric;
    }

    private @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metric>> isSparkBeamMetric() {
        return metricEntry -> metricEntry.getValue() instanceof SparkBeamMetric;
    }
}

