/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.util.List;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface SparkCommonPipelineOptions
extends PipelineOptions,
StreamingOptions,
ApplicationNameOptions {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_MASTER_URL = "local[4]";

    @Description(value="The url of the spark master to connect to, (e.g. spark://host:port, local[4]).")
    @Default.String(value="local[4]")
    public @UnknownKeyFor @NonNull @Initialized String getSparkMaster();

    public void setSparkMaster(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="A checkpoint directory for streaming resilience, ignored in batch. For durability, a reliable filesystem such as HDFS/S3/GS is necessary.")
    @Default.InstanceFactory(value=TmpCheckpointDirFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getCheckpointDir();

    public void setCheckpointDir(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Jar-Files to send to all workers and put on the classpath. The default value is all files from the classpath.")
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getFilesToStage();

    public void setFilesToStage(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Enable/disable sending aggregator values to Spark's metric sinks")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized Boolean getEnableSparkMetricSinks();

    public void setEnableSparkMetricSinks(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    public static class TmpCheckpointDirFactory
    implements DefaultValueFactory<String> {
        public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return "/tmp/" + options.getJobName();
        }
    }
}

