/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public final class RowHelpers {
    public static <T> MapFunction<Row, WindowedValue<T>> extractWindowedValueFromRowMapFunction(WindowedValue.WindowedValueCoder<T> windowedValueCoder) {
        return (MapFunction & Serializable)value -> {
            byte[] bytes = (byte[])value.get(0);
            return (WindowedValue)windowedValueCoder.decode((InputStream)new ByteArrayInputStream(bytes));
        };
    }

    public static <T> InternalRow storeWindowedValueInRow(WindowedValue<T> windowedValue, Coder<T> coder) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.FullWindowedValueCoder.of(coder, (Coder)GlobalWindow.Coder.INSTANCE);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            windowedValueCoder.encode(windowedValue, (OutputStream)byteArrayOutputStream);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            list.add(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return InternalRow.apply((Seq)JavaConversions.asScalaBuffer(list).toList());
    }
}

