/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.beam.runners.spark.structuredstreaming.translation.SchemaHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.ObjectType;
import scala.StringContext;
import scala.collection.JavaConversions;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class EncoderHelpers {
    public static <T> Encoder<T> fromBeamCoder(Coder<T> beamCoder) {
        ArrayList<EncodeUsingBeamCoder<T>> serialiserList = new ArrayList<EncodeUsingBeamCoder<T>>();
        Class claz = beamCoder.getEncodedTypeDescriptor().getRawType();
        serialiserList.add(new EncodeUsingBeamCoder<T>((Expression)new BoundReference(0, (DataType)new ObjectType(claz), true), beamCoder));
        ClassTag classTag = ClassTag$.MODULE$.apply(claz);
        return new ExpressionEncoder(SchemaHelpers.binarySchema(), false, JavaConversions.collectionAsScalaIterable(serialiserList).toSeq(), new DecodeUsingBeamCoder<T>((Expression)new Cast((Expression)new GetColumnByOrdinal(0, DataTypes.BinaryType), DataTypes.BinaryType), classTag, beamCoder), classTag);
    }

    public static class DecodeUsingBeamCoder<T>
    extends UnaryExpression
    implements NonSQLExpression,
    Serializable {
        private Expression child;
        private ClassTag<T> classTag;
        private Coder<T> beamCoder;

        public DecodeUsingBeamCoder(Expression child, ClassTag<T> classTag, Coder<T> beamCoder) {
            this.child = child;
            this.classTag = classTag;
            this.beamCoder = beamCoder;
        }

        public Expression child() {
            return this.child;
        }

        public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
            String accessCode = ctx.addReferenceObj("beamCoder", this.beamCoder, this.beamCoder.getClass().getName());
            ExprCode input = this.child.genCode(ctx);
            String javaType = CodeGenerator.javaType((DataType)this.dataType());
            ArrayList<String> parts = new ArrayList<String>();
            parts.add("final ");
            parts.add(" ");
            parts.add(";try { ");
            parts.add(" = ");
            parts.add("? ");
            parts.add(": (");
            parts.add(") ");
            parts.add(".decode(new java.io.ByteArrayInputStream(");
            parts.add("));  } catch (Exception e) {throw org.apache.beam.sdk.util.UserCodeException.wrap(e);}");
            StringContext sc = new StringContext(JavaConversions.collectionAsScalaIterable(parts).toSeq());
            ArrayList<String> args = new ArrayList<String>();
            args.add(javaType);
            args.add((String)ev.value());
            args.add((String)ev.value());
            args.add((String)input.isNull());
            args.add(CodeGenerator.defaultValue((DataType)this.dataType(), (boolean)false));
            args.add(javaType);
            args.add(accessCode);
            args.add((String)input.value());
            Block code = new Block.BlockHelper(sc).code(JavaConversions.collectionAsScalaIterable(args).toSeq());
            return ev.copy(input.code().$plus(code), input.isNull(), ev.value());
        }

        public Object nullSafeEval(Object input) {
            try {
                return this.beamCoder.decode((InputStream)new ByteArrayInputStream((byte[])input));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error decoding bytes for coder: " + this.beamCoder, e);
            }
        }

        public DataType dataType() {
            return new ObjectType(this.classTag.runtimeClass());
        }

        public Object productElement(int n) {
            switch (n) {
                case 0: {
                    return this.child;
                }
                case 1: {
                    return this.classTag;
                }
                case 2: {
                    return this.beamCoder;
                }
            }
            throw new ArrayIndexOutOfBoundsException("productElement out of bounds");
        }

        public int productArity() {
            return 3;
        }

        public boolean canEqual(Object that) {
            return that instanceof DecodeUsingBeamCoder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecodeUsingBeamCoder that = (DecodeUsingBeamCoder)o;
            return this.child.equals(that.child) && this.classTag.equals(that.classTag) && this.beamCoder.equals(that.beamCoder);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.child, this.classTag, this.beamCoder);
        }
    }

    public static class EncodeUsingBeamCoder<T>
    extends UnaryExpression
    implements NonSQLExpression,
    Serializable {
        private Expression child;
        private Coder<T> beamCoder;

        public EncodeUsingBeamCoder(Expression child, Coder<T> beamCoder) {
            this.child = child;
            this.beamCoder = beamCoder;
        }

        public Expression child() {
            return this.child;
        }

        public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
            String accessCode = ctx.addReferenceObj("beamCoder", this.beamCoder, this.beamCoder.getClass().getName());
            ExprCode input = this.child.genCode(ctx);
            ArrayList<String> parts = new ArrayList<String>();
            parts.add("byte[] ");
            parts.add(";try { java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream(); if (");
            parts.add(") ");
            parts.add(" = null; else{");
            parts.add(".encode(");
            parts.add(", baos); ");
            parts.add(" = baos.toByteArray();}} catch (Exception e) {throw org.apache.beam.sdk.util.UserCodeException.wrap(e);}");
            StringContext sc = new StringContext(JavaConversions.collectionAsScalaIterable(parts).toSeq());
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(ev.value());
            args.add(input.isNull());
            args.add(ev.value());
            args.add(accessCode);
            args.add(input.value());
            args.add(ev.value());
            Block code = new Block.BlockHelper(sc).code(JavaConversions.collectionAsScalaIterable(args).toSeq());
            return ev.copy(input.code().$plus(code), input.isNull(), ev.value());
        }

        public DataType dataType() {
            return DataTypes.BinaryType;
        }

        public Object productElement(int n) {
            switch (n) {
                case 0: {
                    return this.child;
                }
                case 1: {
                    return this.beamCoder;
                }
            }
            throw new ArrayIndexOutOfBoundsException("productElement out of bounds");
        }

        public int productArity() {
            return 2;
        }

        public boolean canEqual(Object that) {
            return that instanceof EncodeUsingBeamCoder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodeUsingBeamCoder that = (EncodeUsingBeamCoder)o;
            return this.beamCoder.equals(that.beamCoder) && this.child.equals(that.child);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.child, this.beamCoder);
        }
    }
}

