/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class SparkSideInputReader
implements SideInputReader {
    private final Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs;

    public SparkSideInputReader(Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs) {
        this.sideInputs = sideInputs;
    }

    @Nullable
    public <T> T get(PCollectionView<T> view, BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"The PCollectionView passed to sideInput cannot be null ");
        KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>> windowedBroadcastHelper = this.sideInputs.get(view.getTagInternal());
        Preconditions.checkNotNull(windowedBroadcastHelper, (Object)("SideInput for view " + view + " is not available."));
        BoundedWindow sideInputWindow = view.getWindowMappingFn().getSideInputWindow(window);
        Iterable availableSideInputs = (Iterable)((SideInputBroadcast)windowedBroadcastHelper.getValue()).getValue();
        Iterable sideInputForWindow = StreamSupport.stream(availableSideInputs.spliterator(), false).filter(sideInputCandidate -> {
            if (sideInputCandidate == null) {
                return false;
            }
            return Iterables.contains((Iterable)sideInputCandidate.getWindows(), (Object)sideInputWindow);
        }).collect(Collectors.toList()).stream().map(WindowedValue::getValue).collect(Collectors.toList());
        ViewFn viewFn = view.getViewFn();
        Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
        return (T)viewFn.apply((Object)InMemoryMultimapSideInputView.fromIterable((Coder)keyCoder, (Iterable)sideInputForWindow));
    }

    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public boolean isEmpty() {
        return this.sideInputs != null && this.sideInputs.isEmpty();
    }
}

