/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.runners.spark.util.SparkSideInputReader;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

class SparkAbstractCombineFn
implements Serializable {
    private final SerializablePipelineOptions options;
    private final Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs;
    final WindowingStrategy<?, BoundedWindow> windowingStrategy;
    private transient SparkCombineContext combineContext;

    SparkAbstractCombineFn(SerializablePipelineOptions options, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs, WindowingStrategy<?, ?> windowingStrategy) {
        this.options = options;
        this.sideInputs = sideInputs;
        this.windowingStrategy = windowingStrategy;
    }

    SparkCombineContext ctxtForInput(WindowedValue<?> input) {
        if (this.combineContext == null) {
            this.combineContext = new SparkCombineContext(this.options.get(), new SparkSideInputReader(this.sideInputs));
        }
        return this.combineContext.forInput(input);
    }

    static <T> Iterable<WindowedValue<T>> sortByWindows(Iterable<WindowedValue<T>> iter) {
        ArrayList sorted = Lists.newArrayList(iter);
        sorted.sort(Comparator.comparing(o -> ((BoundedWindow)Iterables.getOnlyElement((Iterable)o.getWindows())).maxTimestamp()));
        return sorted;
    }

    static boolean isIntersecting(IntervalWindow union, IntervalWindow window) {
        return union == null || union.intersects(window);
    }

    static IntervalWindow merge(IntervalWindow union, IntervalWindow window) {
        return union == null ? window : union.span(window);
    }

    private static class SparkCombineContext
    extends CombineWithContext.Context {
        private final PipelineOptions pipelineOptions;
        private final SideInputReader sideInputReader;
        private WindowedValue<?> input = null;

        SparkCombineContext(PipelineOptions pipelineOptions, SideInputReader sideInputReader) {
            this.pipelineOptions = pipelineOptions;
            this.sideInputReader = sideInputReader;
        }

        SparkCombineContext forInput(WindowedValue<?> input) {
            this.input = input;
            return this;
        }

        public PipelineOptions getPipelineOptions() {
            return this.pipelineOptions;
        }

        public <T> T sideInput(PCollectionView<T> view) {
            Preconditions.checkNotNull(this.input, (Object)"Input in SparkCombineContext must not be null!");
            Collection elementWindows = this.input.getWindows();
            Preconditions.checkState((elementWindows.size() == 1 ? 1 : 0) != 0, (Object)"sideInput can only be called when the main input element is in exactly one window");
            return (T)this.sideInputReader.get(view, (BoundedWindow)elementWindows.iterator().next());
        }
    }
}

