/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.fnexecution.jobsubmission.JobInvocation;
import org.apache.beam.runners.fnexecution.jobsubmission.JobInvoker;
import org.apache.beam.runners.fnexecution.jobsubmission.PortablePipelineRunner;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.spark.SparkJobServerDriver;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.SparkPipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v20_0.com.google.common.util.concurrent.ListeningExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkJobInvoker
extends JobInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(SparkJobInvoker.class);
    private SparkJobServerDriver.SparkServerConfiguration configuration;

    public static SparkJobInvoker create(SparkJobServerDriver.SparkServerConfiguration configuration) {
        return new SparkJobInvoker(configuration);
    }

    private SparkJobInvoker(SparkJobServerDriver.SparkServerConfiguration configuration) {
        super("spark-runner-job-invoker");
        this.configuration = configuration;
    }

    protected JobInvocation invokeWithExecutor(RunnerApi.Pipeline pipeline, Struct options, @Nullable String retrievalToken, ListeningExecutorService executorService) {
        LOG.trace("Parsing pipeline options");
        SparkPipelineOptions sparkOptions = (SparkPipelineOptions)PipelineOptionsTranslation.fromProto((Struct)options).as(SparkPipelineOptions.class);
        String invocationId = String.format("%s_%s", sparkOptions.getJobName(), UUID.randomUUID().toString());
        LOG.info("Invoking job {}", (Object)invocationId);
        if (sparkOptions.getSparkMaster().equals("local[4]")) {
            sparkOptions.setSparkMaster(this.configuration.getSparkMasterUrl());
        }
        sparkOptions.setRunner(null);
        if (sparkOptions.getAppName() == null) {
            LOG.debug("App name was null. Using invocationId {}", (Object)invocationId);
            sparkOptions.setAppName(invocationId);
        }
        return SparkJobInvoker.createJobInvocation(invocationId, retrievalToken, executorService, pipeline, sparkOptions);
    }

    static JobInvocation createJobInvocation(String invocationId, String retrievalToken, ListeningExecutorService executorService, RunnerApi.Pipeline pipeline, SparkPipelineOptions sparkOptions) {
        JobInfo jobInfo = JobInfo.create((String)invocationId, (String)sparkOptions.getJobName(), (String)retrievalToken, (Struct)PipelineOptionsTranslation.toProto((PipelineOptions)sparkOptions));
        SparkPipelineRunner pipelineRunner = new SparkPipelineRunner(sparkOptions);
        return new JobInvocation(jobInfo, executorService, pipeline, (PortablePipelineRunner)pipelineRunner);
    }
}

