/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.coders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public final class CoderHelpers {
    private CoderHelpers() {
    }

    public static <T> byte[] toByteArray(T value, Coder<T> coder) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            coder.encode(value, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding value: " + value, e);
        }
        return baos.toByteArray();
    }

    public static <T> List<byte[]> toByteArrays(Iterable<T> values, Coder<T> coder) {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        for (T value : values) {
            res.add(CoderHelpers.toByteArray(value, coder));
        }
        return res;
    }

    public static <T> T fromByteArray(byte[] serialized, Coder<T> coder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        try {
            return (T)coder.decode((InputStream)bais);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
        }
    }

    public static <T> Iterable<T> fromByteArrays(Collection<byte[]> serialized, Coder<T> coder) {
        return serialized.stream().map(bytes -> CoderHelpers.fromByteArray((byte[])Preconditions.checkNotNull((Object)bytes, (Object)"Cannot decode null values."), coder)).collect(Collectors.toList());
    }

    public static <T> Function<T, byte[]> toByteFunction(Coder<T> coder) {
        return (Function & Serializable)t -> CoderHelpers.toByteArray(t, coder);
    }

    public static <T> Function<byte[], T> fromByteFunction(Coder<T> coder) {
        return (Function & Serializable)bytes -> CoderHelpers.fromByteArray(bytes, coder);
    }

    public static <K, V> PairFunction<Tuple2<K, V>, ByteArray, byte[]> toByteFunction(Coder<K> keyCoder, Coder<V> valueCoder) {
        return (PairFunction & Serializable)kv -> new Tuple2((Object)new ByteArray(CoderHelpers.toByteArray(kv._1(), keyCoder)), (Object)CoderHelpers.toByteArray(kv._2(), valueCoder));
    }

    public static <K, V> PairFunction<Tuple2<ByteArray, byte[]>, K, V> fromByteFunction(Coder<K> keyCoder, Coder<V> valueCoder) {
        return (PairFunction & Serializable)tuple -> new Tuple2(CoderHelpers.fromByteArray(((ByteArray)tuple._1()).getValue(), keyCoder), CoderHelpers.fromByteArray((byte[])tuple._2(), valueCoder));
    }

    public static <K, V> PairFunction<Tuple2<ByteArray, Iterable<byte[]>>, K, Iterable<V>> fromByteFunctionIterable(Coder<K> keyCoder, Coder<V> valueCoder) {
        return (PairFunction & Serializable)tuple -> new Tuple2(CoderHelpers.fromByteArray(((ByteArray)tuple._1()).getValue(), keyCoder), (Object)StreamSupport.stream(((Iterable)tuple._2()).spliterator(), false).map(bytes -> CoderHelpers.fromByteArray(bytes, valueCoder)).collect(Collectors.toList()));
    }
}

