/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkPCollectionView
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SparkPCollectionView.class);
    private volatile transient Map<PCollectionView<?>, SideInputBroadcast> broadcastHelperMap = null;
    private Map<PCollectionView<?>, Tuple2<byte[], Coder<Iterable<WindowedValue<?>>>>> pviews = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void putPView(PCollectionView<?> view, Iterable<WindowedValue<?>> value, Coder<Iterable<WindowedValue<?>>> coder) {
        this.pviews.put(view, new Tuple2((Object)CoderHelpers.toByteArray(value, coder), coder));
        if (this.broadcastHelperMap == null) return;
        Class<SparkPCollectionView> clazz = SparkPCollectionView.class;
        synchronized (SparkPCollectionView.class) {
            SideInputBroadcast helper = this.broadcastHelperMap.get(view);
            if (helper == null) return;
            helper.unpersist();
            this.broadcastHelperMap.remove(view);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    SideInputBroadcast getPCollectionView(PCollectionView<?> view, JavaSparkContext context) {
        SideInputBroadcast helper;
        if (this.broadcastHelperMap == null) {
            Class<SparkPCollectionView> clazz = SparkPCollectionView.class;
            // MONITORENTER : org.apache.beam.runners.spark.translation.SparkPCollectionView.class
            if (this.broadcastHelperMap == null) {
                this.broadcastHelperMap = new LinkedHashMap();
            }
            // MONITOREXIT : clazz
        }
        if ((helper = this.broadcastHelperMap.get(view)) != null) return helper;
        Class<SparkPCollectionView> clazz = SparkPCollectionView.class;
        // MONITORENTER : org.apache.beam.runners.spark.translation.SparkPCollectionView.class
        helper = this.broadcastHelperMap.get(view);
        if (helper == null) {
            helper = this.createBroadcastHelper(view, context);
        }
        // MONITOREXIT : clazz
        return helper;
    }

    private SideInputBroadcast createBroadcastHelper(PCollectionView<?> view, JavaSparkContext context) {
        Tuple2<byte[], Coder<Iterable<WindowedValue<?>>>> tuple2 = this.pviews.get(view);
        SideInputBroadcast helper = SideInputBroadcast.create((byte[])tuple2._1, (Coder)tuple2._2);
        String pCollectionName = view.getPCollection() != null ? view.getPCollection().getName() : "UNKNOWN";
        LOG.debug("Broadcasting [size={}B] view {} from pCollection {}", new Object[]{helper.getBroadcastSizeEstimate(), view, pCollectionName});
        helper.broadcast(context);
        this.broadcastHelperMap.put(view, helper);
        return helper;
    }
}

