/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkKeyedCombineFn;
import org.apache.beam.runners.spark.translation.SparkPCollectionView;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.joda.time.Instant;
import scala.Tuple2;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    public static <T, W extends BoundedWindow> boolean skipAssignWindows(Window.Assign<T> transform, EvaluationContext context) {
        WindowFn windowFn = transform.getWindowFn();
        return windowFn == null || ((PCollection)context.getInput(transform)).getWindowingStrategy().getWindowFn() instanceof GlobalWindows && windowFn instanceof GlobalWindows;
    }

    public static <T1, T2> JavaDStream<T2> dStreamValues(JavaPairDStream<T1, T2> pairDStream) {
        return pairDStream.map(Tuple2::_2);
    }

    public static <K, V> PairFunction<KV<K, V>, K, V> toPairFunction() {
        return (PairFunction & Serializable)kv -> new Tuple2(kv.getKey(), kv.getValue());
    }

    public static <K, V> PairFlatMapFunction<Iterator<KV<K, V>>, K, V> toPairFlatMapFunction() {
        return (PairFlatMapFunction & Serializable)itr -> {
            Iterator outputItr = Iterators.transform((Iterator)itr, kv -> new Tuple2(kv.getKey(), kv.getValue()));
            return outputItr;
        };
    }

    static <K, V> Function<Tuple2<K, V>, KV<K, V>> fromPairFunction() {
        return (Function & Serializable)t2 -> KV.of((Object)t2._1(), (Object)t2._2());
    }

    static <K, V> FlatMapFunction<Iterator<Tuple2<K, V>>, KV<K, V>> fromPairFlatMapFunction() {
        return (FlatMapFunction & Serializable)itr -> Iterators.transform((Iterator)itr, t2 -> KV.of((Object)t2._1(), (Object)t2._2()));
    }

    public static <K, V> PairFunction<WindowedValue<KV<K, V>>, K, WindowedValue<KV<K, V>>> toPairByKeyInWindowedValue() {
        return (PairFunction & Serializable)windowedKv -> new Tuple2(((KV)windowedKv.getValue()).getKey(), windowedKv);
    }

    static <K, V> Function<KV<K, WindowedValue<V>>, WindowedValue<KV<K, V>>> toKVByWindowInValue() {
        return (Function & Serializable)kv -> {
            WindowedValue wv = (WindowedValue)kv.getValue();
            return wv.withValue((Object)KV.of((Object)kv.getKey(), (Object)wv.getValue()));
        };
    }

    static Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> getSideInputs(List<PCollectionView<?>> views, EvaluationContext context) {
        return TranslationUtils.getSideInputs(views, context.getSparkContext(), context.getPViews());
    }

    public static Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> getSideInputs(List<PCollectionView<?>> views, JavaSparkContext context, SparkPCollectionView pviews) {
        if (views == null) {
            return ImmutableMap.of();
        }
        HashMap sideInputs = Maps.newHashMap();
        for (PCollectionView<?> view : views) {
            SideInputBroadcast helper = pviews.getPCollectionView(view, context);
            WindowingStrategy windowingStrategy = view.getWindowingStrategyInternal();
            sideInputs.put(view.getTagInternal(), KV.of((Object)windowingStrategy, (Object)helper));
        }
        return sideInputs;
    }

    public static void rejectStateAndTimers(DoFn<?, ?> doFn) {
        DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.stateDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with state in the %s.", DoFn.StateId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
        if (signature.timerDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with timers in the %s.", DoFn.TimerId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
    }

    public static <T> VoidFunction<T> emptyVoidFunction() {
        return (VoidFunction & Serializable)t -> {};
    }

    public static <T, K, V> PairFlatMapFunction<Iterator<T>, K, V> pairFunctionToPairFlatMapFunction(PairFunction<T, K, V> pairFunction) {
        return (PairFlatMapFunction & Serializable)itr -> {
            Iterator outputItr = Iterators.transform((Iterator)itr, t -> {
                try {
                    return pairFunction.call(t);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            return outputItr;
        };
    }

    public static <InputT, OutputT> FlatMapFunction<Iterator<InputT>, OutputT> functionToFlatMapFunction(Function<InputT, OutputT> func) {
        return (FlatMapFunction & Serializable)itr -> {
            Iterator outputItr = Iterators.transform((Iterator)itr, t -> {
                try {
                    return func.call(t);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            return outputItr;
        };
    }

    public static Map<TupleTag<?>, Coder<WindowedValue<?>>> getTupleTagCoders(Map<TupleTag<?>, PValue> outputs) {
        HashMap coderMap = new HashMap(outputs.size());
        for (Map.Entry<TupleTag<?>, PValue> output : outputs.entrySet()) {
            PCollection pCollection = (PCollection)output.getValue();
            Coder coder = pCollection.getCoder();
            Coder wCoder = pCollection.getWindowingStrategy().getWindowFn().windowCoder();
            WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.getFullCoder((Coder)coder, (Coder)wCoder);
            coderMap.put(output.getKey(), (Coder<WindowedValue<?>>)windowedValueCoder);
        }
        return coderMap;
    }

    public static PairFunction<Tuple2<TupleTag<?>, WindowedValue<?>>, TupleTag<?>, byte[]> getTupleTagEncodeFunction(Map<TupleTag<?>, Coder<WindowedValue<?>>> coderMap) {
        return (PairFunction & Serializable)tuple2 -> {
            TupleTag tupleTag = (TupleTag)tuple2._1;
            WindowedValue windowedValue = (WindowedValue)tuple2._2;
            return new Tuple2((Object)tupleTag, (Object)CoderHelpers.toByteArray(windowedValue, (Coder)coderMap.get(tupleTag)));
        };
    }

    public static PairFunction<Tuple2<TupleTag<?>, byte[]>, TupleTag<?>, WindowedValue<?>> getTupleTagDecodeFunction(Map<TupleTag<?>, Coder<WindowedValue<?>>> coderMap) {
        return (PairFunction & Serializable)tuple2 -> {
            TupleTag tupleTag = (TupleTag)tuple2._1;
            byte[] windowedByteValue = (byte[])tuple2._2;
            return new Tuple2((Object)tupleTag, (Object)((WindowedValue)CoderHelpers.fromByteArray(windowedByteValue, (Coder)coderMap.get(tupleTag))));
        };
    }

    public static boolean avoidRddSerialization(StorageLevel level) {
        return level.equals((Object)StorageLevel.MEMORY_ONLY()) || level.equals((Object)StorageLevel.MEMORY_ONLY_2());
    }

    public static final class TupleTagFilter<V>
    implements Function<Tuple2<TupleTag<V>, WindowedValue<?>>, Boolean> {
        private final TupleTag<V> tag;

        public TupleTagFilter(TupleTag<V> tag) {
            this.tag = tag;
        }

        public Boolean call(Tuple2<TupleTag<V>, WindowedValue<?>> input) {
            return this.tag.equals(input._1());
        }
    }

    public static class CombineGroupedValues<K, InputT, OutputT>
    implements Function<WindowedValue<KV<K, Iterable<InputT>>>, WindowedValue<KV<K, OutputT>>> {
        private final SparkKeyedCombineFn<K, InputT, ?, OutputT> fn;

        public CombineGroupedValues(SparkKeyedCombineFn<K, InputT, ?, OutputT> fn) {
            this.fn = fn;
        }

        public WindowedValue<KV<K, OutputT>> call(WindowedValue<KV<K, Iterable<InputT>>> windowedKv) throws Exception {
            return WindowedValue.of((Object)KV.of((Object)((KV)windowedKv.getValue()).getKey(), this.fn.apply(windowedKv)), (Instant)windowedKv.getTimestamp(), (Collection)windowedKv.getWindows(), (PaneInfo)windowedKv.getPane());
        }
    }

    static class InMemoryStateInternalsFactory<K>
    implements StateInternalsFactory<K>,
    Serializable {
        InMemoryStateInternalsFactory() {
        }

        public StateInternals stateInternalsForKey(K key) {
            return InMemoryStateInternals.forKey(key);
        }
    }
}

