/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;

public class CachedSideInputReader
implements SideInputReader {
    private final SideInputReader delegate;
    private final Map<Key<?>, ?> materialized = new HashMap();

    public static CachedSideInputReader of(SideInputReader delegate) {
        return new CachedSideInputReader(delegate);
    }

    private CachedSideInputReader(SideInputReader delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public <T> T get(PCollectionView<T> view, BoundedWindow window) {
        Map<Key<?>, ?> materializedCasted = this.materialized;
        return (T)materializedCasted.computeIfAbsent(new Key<T>(view, window), key -> this.delegate.get(view, window));
    }

    public <T> boolean contains(PCollectionView<T> view) {
        return this.delegate.contains(view);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    private static class Key<T> {
        private final PCollectionView<T> view;
        private final BoundedWindow window;

        Key(PCollectionView<T> view, BoundedWindow window) {
            this.view = view;
            this.window = window;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.view, key.view) && Objects.equals(this.window, key.window);
        }

        public int hashCode() {
            return Objects.hash(this.view, this.window);
        }
    }
}

