/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.WindowingStrategy;

public class SinglePrimitiveOutputPTransform<T>
extends PTransform<PInput, PCollection<T>> {
    private PTransform<PInput, PCollection<T>> transform;

    public SinglePrimitiveOutputPTransform(PTransform<PInput, PCollection<T>> transform) {
        this.transform = transform;
    }

    public PCollection<T> expand(PInput input) {
        try {
            PCollection collection = PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED);
            collection.setCoder(this.transform.getDefaultOutputCoder(input, collection));
            return collection;
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking Create.withCoder() explicitly.", e);
        }
    }
}

