/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.runners.spark.util.BroadcastHelper;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.SideInputReader;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;

public class SparkSideInputReader
implements SideInputReader {
    private final Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, BroadcastHelper<?>>> sideInputs;

    public SparkSideInputReader(Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, BroadcastHelper<?>>> sideInputs) {
        this.sideInputs = sideInputs;
    }

    @Nullable
    public <T> T get(PCollectionView<T> view, BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"The PCollectionView passed to sideInput cannot be null ");
        KV<WindowingStrategy<?, ?>, BroadcastHelper<?>> windowedBroadcastHelper = this.sideInputs.get(view.getTagInternal());
        Preconditions.checkNotNull(windowedBroadcastHelper, (Object)("SideInput for view " + view + " is not available."));
        WindowingStrategy sideInputWindowStrategy = (WindowingStrategy)windowedBroadcastHelper.getKey();
        final BoundedWindow sideInputWindow = sideInputWindowStrategy.getWindowFn().getSideInputWindow(window);
        Iterable availableSideInputs = (Iterable)((BroadcastHelper)windowedBroadcastHelper.getValue()).getValue();
        Iterable sideInputForWindow = Iterables.filter((Iterable)availableSideInputs, (Predicate)new Predicate<WindowedValue<?>>(){

            public boolean apply(@Nullable WindowedValue<?> sideInputCandidate) {
                if (sideInputCandidate == null) {
                    return false;
                }
                for (BoundedWindow sideInputCandidateWindow : sideInputCandidate.getWindows()) {
                    if (!sideInputCandidateWindow.equals(sideInputWindow)) continue;
                    return true;
                }
                return false;
            }
        });
        return (T)view.getViewFn().apply((Object)sideInputForWindow);
    }

    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public boolean isEmpty() {
        return this.sideInputs != null && this.sideInputs.isEmpty();
    }
}

