/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkKeyedCombineFn;
import org.apache.beam.runners.spark.util.BroadcastHelper;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.util.state.InMemoryStateInternals;
import org.apache.beam.sdk.util.state.StateInternals;
import org.apache.beam.sdk.util.state.StateInternalsFactory;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.joda.time.Instant;
import scala.Tuple2;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    public static <T, W extends BoundedWindow> boolean skipAssignWindows(Window.Bound<T> transform, EvaluationContext context) {
        WindowFn windowFn = transform.getWindowFn();
        return windowFn == null || ((PCollection)context.getInput(transform)).getWindowingStrategy().getWindowFn() instanceof GlobalWindows && windowFn instanceof GlobalWindows;
    }

    public static <T1, T2> JavaDStream<T2> dStreamValues(JavaPairDStream<T1, T2> pairDStream) {
        return pairDStream.map(new Function<Tuple2<T1, T2>, T2>(){

            public T2 call(Tuple2<T1, T2> v1) throws Exception {
                return v1._2();
            }
        });
    }

    static <K, V> PairFunction<KV<K, V>, K, V> toPairFunction() {
        return new PairFunction<KV<K, V>, K, V>(){

            public Tuple2<K, V> call(KV<K, V> kv) {
                return new Tuple2(kv.getKey(), kv.getValue());
            }
        };
    }

    static <K, V> Function<Tuple2<K, V>, KV<K, V>> fromPairFunction() {
        return new Function<Tuple2<K, V>, KV<K, V>>(){

            public KV<K, V> call(Tuple2<K, V> t2) {
                return KV.of((Object)t2._1(), (Object)t2._2());
            }
        };
    }

    public static <T> FlatMapFunction<Iterator<T>, T> flattenIter() {
        return new FlatMapFunction<Iterator<T>, T>(){

            public Iterable<T> call(final Iterator<T> t) throws Exception {
                return new Iterable<T>(){

                    @Override
                    public Iterator<T> iterator() {
                        return t;
                    }
                };
            }
        };
    }

    public static Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, BroadcastHelper<?>>> getSideInputs(List<PCollectionView<?>> views, EvaluationContext context) {
        if (views == null) {
            return ImmutableMap.of();
        }
        HashMap sideInputs = Maps.newHashMap();
        for (PCollectionView<?> view : views) {
            Iterable<WindowedValue<?>> collectionView = context.getPCollectionView(view);
            Coder coderInternal = view.getCoderInternal();
            WindowingStrategy windowingStrategy = view.getWindowingStrategyInternal();
            BroadcastHelper<Iterable<WindowedValue<?>>> helper = BroadcastHelper.create(collectionView, coderInternal);
            helper.broadcast(context.getSparkContext());
            sideInputs.put(view.getTagInternal(), KV.of((Object)windowingStrategy, helper));
        }
        return sideInputs;
    }

    public static void rejectStateAndTimers(DoFn<?, ?> doFn) {
        DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.stateDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with state in the %s.", DoFn.StateId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
        if (signature.timerDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with timers in the %s.", DoFn.TimerId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
    }

    public static final class TupleTagFilter<V>
    implements Function<Tuple2<TupleTag<V>, WindowedValue<?>>, Boolean> {
        private final TupleTag<V> tag;

        public TupleTagFilter(TupleTag<V> tag) {
            this.tag = tag;
        }

        public Boolean call(Tuple2<TupleTag<V>, WindowedValue<?>> input) {
            return this.tag.equals(input._1());
        }
    }

    public static class CombineGroupedValues<K, InputT, OutputT>
    implements Function<WindowedValue<KV<K, Iterable<InputT>>>, WindowedValue<KV<K, OutputT>>> {
        private final SparkKeyedCombineFn<K, InputT, ?, OutputT> fn;

        public CombineGroupedValues(SparkKeyedCombineFn<K, InputT, ?, OutputT> fn) {
            this.fn = fn;
        }

        public WindowedValue<KV<K, OutputT>> call(WindowedValue<KV<K, Iterable<InputT>>> windowedKv) throws Exception {
            return WindowedValue.of((Object)KV.of((Object)((KV)windowedKv.getValue()).getKey(), this.fn.apply(windowedKv)), (Instant)windowedKv.getTimestamp(), (Collection)windowedKv.getWindows(), (PaneInfo)windowedKv.getPane());
        }
    }

    static class InMemoryStateInternalsFactory<K>
    implements StateInternalsFactory<K>,
    Serializable {
        InMemoryStateInternalsFactory() {
        }

        public StateInternals<K> stateInternalsForKey(K key) {
            return InMemoryStateInternals.forKey(key);
        }
    }
}

