/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.runners.spark.translation.WindowingHelpers;
import org.apache.beam.runners.spark.translation.streaming.UnboundedDataset;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingContext;

public class EvaluationContext {
    private final JavaSparkContext jsc;
    private JavaStreamingContext jssc;
    private final SparkRuntimeContext runtime;
    private final Pipeline pipeline;
    private final Map<PValue, Dataset> datasets = new LinkedHashMap<PValue, Dataset>();
    private final Map<PValue, Dataset> pcollections = new LinkedHashMap<PValue, Dataset>();
    private final Set<Dataset> leaves = new LinkedHashSet<Dataset>();
    private final Set<PValue> multiReads = new LinkedHashSet<PValue>();
    private final Map<PValue, Object> pobjects = new LinkedHashMap<PValue, Object>();
    private final Map<PValue, Iterable<? extends WindowedValue<?>>> pview = new LinkedHashMap();
    private AppliedPTransform<?, ?, ?> currentTransform;

    public EvaluationContext(JavaSparkContext jsc, Pipeline pipeline) {
        this.jsc = jsc;
        this.pipeline = pipeline;
        this.runtime = new SparkRuntimeContext(pipeline);
    }

    public EvaluationContext(JavaSparkContext jsc, Pipeline pipeline, JavaStreamingContext jssc) {
        this(jsc, pipeline);
        this.jssc = jssc;
    }

    public JavaSparkContext getSparkContext() {
        return this.jsc;
    }

    public JavaStreamingContext getStreamingContext() {
        return this.jssc;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public SparkRuntimeContext getRuntimeContext() {
        return this.runtime;
    }

    public void setCurrentTransform(AppliedPTransform<?, ?, ?> transform) {
        this.currentTransform = transform;
    }

    public <T extends PInput> T getInput(PTransform<T, ?> transform) {
        Preconditions.checkArgument((this.currentTransform != null && this.currentTransform.getTransform() == transform ? 1 : 0) != 0, (Object)"can only be called with current transform");
        PInput input = this.currentTransform.getInput();
        return (T)input;
    }

    public <T extends POutput> T getOutput(PTransform<?, T> transform) {
        Preconditions.checkArgument((this.currentTransform != null && this.currentTransform.getTransform() == transform ? 1 : 0) != 0, (Object)"can only be called with current transform");
        POutput output = this.currentTransform.getOutput();
        return (T)output;
    }

    public void putDataset(PTransform<?, ?> transform, Dataset dataset) {
        this.putDataset((PValue)this.getOutput(transform), dataset);
    }

    public void putDataset(PValue pvalue, Dataset dataset) {
        try {
            dataset.setName(pvalue.getName());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.datasets.put(pvalue, dataset);
        this.leaves.add(dataset);
    }

    <T> void putBoundedDatasetFromValues(PTransform<?, ?> transform, Iterable<T> values, Coder<T> coder) {
        this.datasets.put((PValue)this.getOutput(transform), new BoundedDataset<T>(values, this.jsc, coder));
    }

    public <T> void putUnboundedDatasetFromQueue(PTransform<?, ?> transform, Iterable<Iterable<T>> values, Coder<T> coder) {
        this.datasets.put((PValue)this.getOutput(transform), new UnboundedDataset<T>(values, this.jssc, coder));
    }

    void putPView(PValue view, Iterable<? extends WindowedValue<?>> value) {
        this.pview.put(view, value);
    }

    public Dataset borrowDataset(PTransform<?, ?> transform) {
        return this.borrowDataset((PValue)this.getInput(transform));
    }

    public Dataset borrowDataset(PValue pvalue) {
        Dataset dataset = this.datasets.get(pvalue);
        this.leaves.remove(dataset);
        if (this.multiReads.contains(pvalue)) {
            dataset.cache(this.storageLevel());
        } else {
            this.multiReads.add(pvalue);
        }
        return dataset;
    }

    <T> Iterable<? extends WindowedValue<?>> getPCollectionView(PCollectionView<T> view) {
        return this.pview.get(view);
    }

    public void computeOutputs() {
        for (Dataset dataset : this.leaves) {
            dataset.cache(this.storageLevel());
            dataset.action();
        }
    }

    public <T> T get(PValue value) {
        if (this.pobjects.containsKey(value)) {
            Object result = this.pobjects.get(value);
            return (T)result;
        }
        if (this.pcollections.containsKey(value)) {
            JavaRDD rdd = ((BoundedDataset)this.pcollections.get(value)).getRDD();
            Object res = Iterables.getOnlyElement((Iterable)rdd.collect());
            this.pobjects.put(value, res);
            return (T)res;
        }
        throw new IllegalStateException("Cannot resolve un-known PObject: " + value);
    }

    public <T> Iterable<T> get(PCollection<T> pcollection) {
        BoundedDataset boundedDataset = (BoundedDataset)this.datasets.get(pcollection);
        Iterable<WindowedValue<T>> windowedValues = boundedDataset.getValues(pcollection);
        return Iterables.transform(windowedValues, WindowingHelpers.unwindowValueFunction());
    }

    <T> Iterable<WindowedValue<T>> getWindowedValues(PCollection<T> pcollection) {
        BoundedDataset boundedDataset = (BoundedDataset)this.datasets.get(pcollection);
        return boundedDataset.getValues(pcollection);
    }

    private String storageLevel() {
        return ((SparkPipelineOptions)this.runtime.getPipelineOptions().as(SparkPipelineOptions.class)).getStorageLevel();
    }
}

