/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io.hadoop;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;

public final class ShardNameBuilder {
    private ShardNameBuilder() {
    }

    public static String replaceShardCount(String template, int shardCount) {
        return ShardNameBuilder.replaceShardPattern(template, "N+", shardCount);
    }

    public static String replaceShardNumber(String template, int shardNumber) {
        return ShardNameBuilder.replaceShardPattern(template, "S+", shardNumber);
    }

    private static String replaceShardPattern(String template, String pattern, int n) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "%1\\$0" + m.group().length() + "d");
        }
        m.appendTail(sb);
        return String.format(sb.toString(), n);
    }

    public static String getOutputDirectory(String pathPrefix, String template) {
        String out = new Path(pathPrefix + template).getParent().toString();
        if (out.isEmpty()) {
            return "./";
        }
        return out;
    }

    public static String getOutputFilePrefix(String pathPrefix, String template) {
        String name = new Path(pathPrefix + template).getName();
        if (name.endsWith(template)) {
            return name.substring(0, name.length() - template.length());
        }
        return "";
    }

    public static String getOutputFileTemplate(String pathPrefix, String template) {
        String name = new Path(pathPrefix + template).getName();
        if (name.endsWith(template)) {
            return template;
        }
        return name;
    }
}

