/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.aggregators.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.aggregators.metrics.AggregatorMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithNamedAggregatorsSupport
extends MetricRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WithNamedAggregatorsSupport.class);
    private MetricRegistry internalMetricRegistry;

    private WithNamedAggregatorsSupport(MetricRegistry internalMetricRegistry) {
        this.internalMetricRegistry = internalMetricRegistry;
    }

    public static WithNamedAggregatorsSupport forRegistry(MetricRegistry metricRegistry) {
        return new WithNamedAggregatorsSupport(metricRegistry);
    }

    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.internalMetricRegistry.getTimers(filter);
    }

    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.internalMetricRegistry.getMeters(filter);
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.internalMetricRegistry.getHistograms(filter);
    }

    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.internalMetricRegistry.getCounters(filter);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return new ImmutableSortedMap.Builder((Comparator)Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER)).putAll((Map)this.internalMetricRegistry.getGauges(filter)).putAll(this.extractGauges(this.internalMetricRegistry, filter)).build();
    }

    private Map<String, Gauge> extractGauges(MetricRegistry metricRegistry, MetricFilter filter) {
        Optional gauges = FluentIterable.from(metricRegistry.getMetrics().entrySet()).firstMatch(this.isAggregatorMetric()).transform(this.toGauges());
        return gauges.isPresent() ? Maps.filterEntries((Map)((Map)gauges.get()), this.matches(filter)) : ImmutableMap.of();
    }

    private Function<Map.Entry<String, Metric>, Map<String, Gauge>> toGauges() {
        return new Function<Map.Entry<String, Metric>, Map<String, Gauge>>(){

            public Map<String, Gauge> apply(Map.Entry<String, Metric> entry) {
                NamedAggregators agg = ((AggregatorMetric)entry.getValue()).getNamedAggregators();
                String parentName = entry.getKey();
                Map gaugeMap = Maps.transformEntries(agg.renderAll(), (Maps.EntryTransformer)WithNamedAggregatorsSupport.this.toGauge());
                LinkedHashMap fullNameGaugeMap = Maps.newLinkedHashMap();
                for (String shortName : gaugeMap.keySet()) {
                    fullNameGaugeMap.put(parentName + "." + shortName, gaugeMap.get(shortName));
                }
                return Maps.filterValues((Map)fullNameGaugeMap, (Predicate)Predicates.notNull());
            }
        };
    }

    private Maps.EntryTransformer<String, Object, Gauge> toGauge() {
        return new Maps.EntryTransformer<String, Object, Gauge>(){

            public Gauge transformEntry(final String name, final Object rawValue) {
                return new Gauge<Double>(){

                    public Double getValue() {
                        try {
                            return Double.parseDouble(rawValue.toString());
                        }
                        catch (Exception e) {
                            LOG.warn("Failed reporting metric with name [{}], of type [{}], since it could not be converted to double", new Object[]{name, rawValue.getClass().getSimpleName(), e});
                            return null;
                        }
                    }
                };
            }
        };
    }

    private Predicate<Map.Entry<String, Gauge>> matches(final MetricFilter filter) {
        return new Predicate<Map.Entry<String, Gauge>>(){

            public boolean apply(Map.Entry<String, Gauge> entry) {
                return filter.matches(entry.getKey(), (Metric)entry.getValue());
            }
        };
    }

    private Predicate<Map.Entry<String, Metric>> isAggregatorMetric() {
        return new Predicate<Map.Entry<String, Metric>>(){

            public boolean apply(Map.Entry<String, Metric> metricEntry) {
                return metricEntry.getValue() instanceof AggregatorMetric;
            }
        };
    }
}

