/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.aggregators;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import org.apache.beam.runners.spark.aggregators.AccumulatorSingleton;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.sdk.AggregatorValues;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.spark.Accumulator;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkAggregators {
    private static <T> AggregatorValues<T> valueOf(Accumulator<NamedAggregators> accum, Aggregator<?, T> aggregator) {
        Class valueType = aggregator.getCombineFn().getOutputType().getRawType();
        final T value = SparkAggregators.valueOf(accum, aggregator.getName(), valueType);
        return new AggregatorValues<T>(){

            public Collection<T> getValues() {
                return ImmutableList.of((Object)value);
            }

            public Map<String, T> getValuesAtSteps() {
                throw new UnsupportedOperationException("getValuesAtSteps is not supported.");
            }
        };
    }

    private static <T> T valueOf(Accumulator<NamedAggregators> accum, String aggregatorName, Class<T> typeClass) {
        return ((NamedAggregators)accum.value()).getValue(aggregatorName, typeClass);
    }

    public static Accumulator<NamedAggregators> getNamedAggregators(JavaSparkContext jsc) {
        return AccumulatorSingleton.getInstance(jsc);
    }

    public static <T> AggregatorValues<T> valueOf(Aggregator<?, T> aggregator, JavaSparkContext javaSparkContext) {
        return SparkAggregators.valueOf(SparkAggregators.getNamedAggregators(javaSparkContext), aggregator);
    }

    public static <T> T valueOf(String name, Class<T> typeClass, JavaSparkContext javaSparkContext) {
        return SparkAggregators.valueOf(SparkAggregators.getNamedAggregators(javaSparkContext), name, typeClass);
    }
}

