/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.SparkPipelineResult;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.runners.PipelineRunner;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public final class TestSparkRunner
extends PipelineRunner<SparkPipelineResult> {
    private SparkRunner delegate;

    private TestSparkRunner(SparkPipelineOptions options) {
        this.delegate = SparkRunner.fromOptions(options);
    }

    public static TestSparkRunner fromOptions(PipelineOptions options) {
        SparkPipelineOptions sparkOptions = (SparkPipelineOptions)PipelineOptionsValidator.validate(SparkPipelineOptions.class, (PipelineOptions)options);
        return new TestSparkRunner(sparkOptions);
    }

    public <OutputT extends POutput, InputT extends PInput> OutputT apply(PTransform<InputT, OutputT> transform, InputT input) {
        return (OutputT)this.delegate.apply(transform, input);
    }

    public SparkPipelineResult run(Pipeline pipeline) {
        TestPipelineOptions testPipelineOptions = (TestPipelineOptions)pipeline.getOptions().as(TestPipelineOptions.class);
        SparkPipelineResult result = this.delegate.run(pipeline);
        result.waitUntilFinish();
        MatcherAssert.assertThat((Object)result, (Matcher)testPipelineOptions.getOnCreateMatcher());
        MatcherAssert.assertThat((Object)result, (Matcher)testPipelineOptions.getOnSuccessMatcher());
        return result;
    }
}

