/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.io.IOException;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.samza.SamzaExecutionContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.LocalApplicationRunner;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPipelineResult
implements PipelineResult {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaPipelineResult.class);
    private final SamzaExecutionContext executionContext;
    private final ApplicationRunner runner;
    private final StreamApplication app;

    public SamzaPipelineResult(StreamApplication app, ApplicationRunner runner, SamzaExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.runner = runner;
        this.app = app;
    }

    public PipelineResult.State getState() {
        return this.getStateInfo().state;
    }

    public PipelineResult.State cancel() throws IOException {
        this.runner.kill(this.app);
        return this.getState();
    }

    public PipelineResult.State waitUntilFinish(Duration duration) {
        throw new UnsupportedOperationException("waitUntilFinish(duration) is not supported by the SamzaRunner");
    }

    public PipelineResult.State waitUntilFinish() {
        if (this.runner instanceof LocalApplicationRunner) {
            try {
                ((LocalApplicationRunner)this.runner).waitForFinish();
            }
            catch (Exception e) {
                throw new Pipeline.PipelineExecutionException((Throwable)e);
            }
            StateInfo stateInfo = this.getStateInfo();
            if (stateInfo.state == PipelineResult.State.FAILED) {
                throw stateInfo.error;
            }
            return stateInfo.state;
        }
        throw new UnsupportedOperationException("waitUntilFinish is not supported by the SamzaRunner when running remotely");
    }

    public MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.executionContext.getMetricsContainer().getContainers());
    }

    private StateInfo getStateInfo() {
        ApplicationStatus status = this.runner.status(this.app);
        switch (status.getStatusCode()) {
            case New: {
                return new StateInfo(PipelineResult.State.STOPPED);
            }
            case Running: {
                return new StateInfo(PipelineResult.State.RUNNING);
            }
            case SuccessfulFinish: {
                return new StateInfo(PipelineResult.State.DONE);
            }
            case UnsuccessfulFinish: {
                LOG.error(status.getThrowable().getMessage(), status.getThrowable());
                return new StateInfo(PipelineResult.State.FAILED, new Pipeline.PipelineExecutionException(status.getThrowable()));
            }
        }
        return new StateInfo(PipelineResult.State.UNKNOWN);
    }

    private static class StateInfo {
        private final PipelineResult.State state;
        private final Pipeline.PipelineExecutionException error;

        private StateInfo(PipelineResult.State state) {
            this(state, (Pipeline.PipelineExecutionException)null);
        }

        private StateInfo(PipelineResult.State state, Pipeline.PipelineExecutionException error) {
            this.state = state;
            this.error = error;
        }
    }
}

