/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.samza.serializers.Serde;

public class SamzaCoders {
    private SamzaCoders() {
    }

    public static <T> Coder<WindowedValue<T>> of(PCollection<T> pCollection) {
        Coder coder = pCollection.getCoder();
        Coder windowCoder = pCollection.getWindowingStrategy().getWindowFn().windowCoder();
        return WindowedValue.FullWindowedValueCoder.of((Coder)coder, (Coder)windowCoder);
    }

    public static <T> Serde<T> toSerde(final Coder<T> coder) {
        return new Serde<T>(){

            public T fromBytes(byte[] bytes) {
                if (bytes != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    try {
                        return coder.decode((InputStream)bais);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }

            public byte[] toBytes(T t) {
                if (t != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        coder.encode(t, (OutputStream)baos);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return baos.toByteArray();
                }
                return null;
            }
        };
    }
}

