/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.serialization.Base64Serializer;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.SamzaTestStreamSystemFactory;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.runners.samza.util.SamzaPipelineTranslatorUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.TestStreamTranslation;
import org.apache.beam.sdk.util.construction.graph.QueryablePipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.samza.operators.KV;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.GenericInputDescriptor;
import org.apache.samza.system.descriptors.GenericSystemDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SamzaTestStreamTranslator<@UnknownKeyFor T>
implements TransformTranslator<TestStream<T>> {
    public static final @UnknownKeyFor @NonNull @Initialized String ENCODED_TEST_STREAM = "encodedTestStream";
    public static final @UnknownKeyFor @NonNull @Initialized String TEST_STREAM_DECODER = "testStreamDecoder";

    @Override
    public void translate(@UnknownKeyFor @NonNull @Initialized TestStream<T> testStream, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized TranslationContext ctx) {
        String encodedTestStream;
        PCollection output = (PCollection)ctx.getOutput(testStream);
        String outputId = ctx.getIdForPValue((PValue)output);
        Coder valueCoder = testStream.getValueCoder();
        TestStream.TestStreamCoder testStreamCoder = TestStream.TestStreamCoder.of((Coder)valueCoder);
        try {
            encodedTestStream = CoderUtils.encodeToBase64((Coder)testStreamCoder, testStream);
        }
        catch (CoderException e) {
            throw new RuntimeException("Could not encode TestStream.", e);
        }
        SerializableFunction & Serializable testStreamDecoder = (SerializableFunction & Serializable)string -> {
            try {
                return (TestStream)CoderUtils.decodeFromBase64((Coder)TestStream.TestStreamCoder.of((Coder)valueCoder), (String)string);
            }
            catch (CoderException e) {
                throw new RuntimeException("Could not decode TestStream.", e);
            }
        };
        ctx.registerInputMessageStream((PValue)output, SamzaTestStreamTranslator.createInputDescriptor(outputId, encodedTestStream, testStreamDecoder));
    }

    @Override
    public void translatePortable(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline, @UnknownKeyFor @NonNull @Initialized PortableTranslationContext ctx) {
        ByteString bytes = transform.getTransform().getSpec().getPayload();
        SerializableFunction<String, TestStream<T>> testStreamDecoder = SamzaTestStreamTranslator.createTestStreamDecoder(pipeline.getComponents(), bytes);
        String outputId = ctx.getOutputId(transform);
        String escapedOutputId = SamzaPipelineTranslatorUtils.escape(outputId);
        ctx.registerInputMessageStream(outputId, SamzaTestStreamTranslator.createInputDescriptor(escapedOutputId, Base64Serializer.serializeUnchecked((Serializable)bytes), testStreamDecoder));
    }

    private static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized GenericInputDescriptor<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized OpMessage<T>>> createInputDescriptor(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized String encodedTestStream, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TestStream<T>> testStreamDecoder) {
        ImmutableMap systemConfig = ImmutableMap.of((Object)ENCODED_TEST_STREAM, (Object)encodedTestStream, (Object)TEST_STREAM_DECODER, (Object)Base64Serializer.serializeUnchecked(testStreamDecoder));
        GenericSystemDescriptor systemDescriptor = (GenericSystemDescriptor)new GenericSystemDescriptor(id, SamzaTestStreamSystemFactory.class.getName()).withSystemConfigs((Map)systemConfig);
        KVSerde kvSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
        return systemDescriptor.getInputDescriptor(id, (Serde)kvSerde);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TestStream<T>> createTestStreamDecoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized ByteString payload) {
        Coder coder;
        try {
            coder = RehydratedComponents.forComponents((RunnerApi.Components)components).getCoder(RunnerApi.TestStreamPayload.parseFrom((ByteString)payload).getCoderId());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (SerializableFunction & Serializable)encodedTestStream -> {
            try {
                return TestStreamTranslation.testStreamFromProtoPayload((RunnerApi.TestStreamPayload)RunnerApi.TestStreamPayload.parseFrom((ByteString)((ByteString)Base64Serializer.deserializeUnchecked((String)encodedTestStream, ByteString.class))), (Coder)coder);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not decode TestStream.", e);
            }
        };
    }
}

