/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SamzaPipelineOptionsValidator {
    public static void validate(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions opts) {
        Preconditions.checkArgument((opts.getMaxSourceParallelism() >= 1 ? 1 : 0) != 0);
        SamzaPipelineOptionsValidator.validateBundlingRelatedOptions(opts);
    }

    static void validateBundlingRelatedOptions(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions) {
        if (pipelineOptions.getMaxBundleSize() > 1L) {
            Map<Object, Object> configs = pipelineOptions.getConfigOverride() == null ? new HashMap() : pipelineOptions.getConfigOverride();
            JobConfig jobConfig = new JobConfig((Config)new MapConfig(configs));
            Preconditions.checkArgument((jobConfig.getThreadPoolSize() <= 1 ? 1 : 0) != 0, (Object)"job.container.thread.pool.size config should be replaced with SamzaPipelineOptions.numThreadsForProcessElement");
        }
    }
}

