/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.samza.translation.SamzaPublishView;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PViewToIdMapper
extends Pipeline.PipelineVisitor.Defaults {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized String> idMap = new HashMap<PValue, String>();
    private @UnknownKeyFor @NonNull @Initialized int nextId;

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized String> buildIdMap(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        PViewToIdMapper mapper = new PViewToIdMapper();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)mapper);
        return mapper.getIdMap();
    }

    private PViewToIdMapper() {
    }

    public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
        String valueDesc = PViewToIdMapper.pValueToString(value).replaceFirst(".*:([a-zA-Z#0-9]+).*", "$1");
        String samzaSafeValueDesc = valueDesc.replaceAll("[^A-Za-z0-9_-]", "_");
        this.idMap.put(value, String.format("%d-%s", this.nextId++, samzaSafeValueDesc));
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        if (node.getTransform() instanceof SamzaPublishView) {
            PCollectionView view = ((SamzaPublishView)node.getTransform()).getView();
            this.visitValue((PValue)view, node);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized String> getIdMap() {
        return Collections.unmodifiableMap(this.idMap);
    }

    private static @UnknownKeyFor @NonNull @Initialized String pValueToString(@UnknownKeyFor @NonNull @Initialized PValue value) {
        String name;
        try {
            name = value.getName();
        }
        catch (IllegalStateException e) {
            name = "<unnamed>";
        }
        return name + " [" + NameUtils.approximateSimpleName(value.getClass()) + "]";
    }
}

