/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class FutureUtils {
    public static <T> @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized Collection<T>> flattenFutures(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized CompletionStage<T>> inputFutures) {
        CompletableFuture[] futures = inputFutures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(futures).thenApply(ignored -> {
            List result = Stream.of(futures).map(CompletableFuture::join).collect(Collectors.toList());
            return result;
        });
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized Collection<T>> combineFutures(@UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized Collection<T>> future1, @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized Collection<T>> future2) {
        if (future1 == null) {
            return future2;
        }
        if (future2 == null) {
            return future1;
        }
        return future1.thenCombine(future2, (c1, c2) -> {
            c1.addAll(c2);
            return c1;
        });
    }
}

