/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.Serializable;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.translation.SamzaPublishView;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.runners.samza.util.SamzaCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SamzaPublishViewTranslator<@UnknownKeyFor ElemT, @UnknownKeyFor ViewT>
implements TransformTranslator<SamzaPublishView<ElemT, ViewT>> {
    SamzaPublishViewTranslator() {
    }

    @Override
    public void translate(@UnknownKeyFor @NonNull @Initialized SamzaPublishView<ElemT, ViewT> transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized TranslationContext ctx) {
        PCollection input = (PCollection)ctx.getInput(transform);
        MessageStream inputStream = ctx.getMessageStream((PValue)input);
        Coder elementCoder = SamzaCoders.of(input);
        String viewId = ctx.getViewId(transform.getView());
        MessageStream<OpMessage<Iterable<ElemT>>> outputStream = SamzaPublishViewTranslator.doTranslate(inputStream, elementCoder, ctx.getTransformId(), viewId, ctx.getPipelineOptions());
        ctx.registerViewStream(transform.getView(), outputStream);
    }

    static <ElemT> @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<@UnknownKeyFor @NonNull @Initialized Iterable<ElemT>>> doTranslate(@UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<@UnknownKeyFor @NonNull @Initialized Iterable<ElemT>>> inputStream, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized Iterable<ElemT>>> coder, @UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String viewId, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options) {
        MessageStream elementStream = inputStream.filter((FilterFunction & Serializable)msg -> msg.getType() == OpMessage.Type.ELEMENT).map(OpMessage::getElement);
        MessageStream broadcastStream = options.getMaxSourceParallelism() == 1 ? elementStream : elementStream.broadcast(SamzaCoders.toSerde(coder), "view-" + transformId);
        return broadcastStream.map((MapFunction & Serializable)element -> OpMessage.ofSideInput(viewId, element));
    }
}

