/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.samza.runtime.DoFnOp;
import org.apache.beam.runners.samza.runtime.KvToKeyedWorkItemOp;
import org.apache.beam.runners.samza.runtime.OpAdapter;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.runtime.SplittableParDoProcessKeyedElementsOp;
import org.apache.beam.runners.samza.translation.ParDoBoundMultiTranslator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.runners.samza.util.SamzaCoders;
import org.apache.beam.runners.samza.util.SamzaPipelineTranslatorUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.serializers.KVSerde;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SplittableParDoTranslators {

    static class ProcessKeyedElements<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor WatermarkEstimatorStateT>
    implements TransformTranslator<SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>> {
        ProcessKeyedElements() {
        }

        @Override
        public void translate(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> transform, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized TranslationContext ctx) {
            PCollection input = (PCollection)ctx.getInput(transform);
            ArrayList outputs = new ArrayList(node.getOutputs().entrySet());
            HashMap tagToIndexMap = new HashMap();
            HashMap<Integer, PCollection> indexToPCollectionMap = new HashMap<Integer, PCollection>();
            for (int index = 0; index < outputs.size(); ++index) {
                Map.Entry taggedOutput = outputs.get(index);
                tagToIndexMap.put((TupleTag)taggedOutput.getKey(), index);
                if (!(taggedOutput.getValue() instanceof PCollection)) {
                    throw new IllegalArgumentException("Expected side output to be PCollection, but was: " + taggedOutput.getValue());
                }
                PCollection sideOutputCollection = (PCollection)taggedOutput.getValue();
                indexToPCollectionMap.put(index, sideOutputCollection);
            }
            WindowingStrategy windowingStrategy = input.getWindowingStrategy();
            MessageStream inputStream = ctx.getMessageStream((PValue)input);
            KvCoder kvInputCoder = (KvCoder)input.getCoder();
            Coder elementCoder = SamzaCoders.of(input);
            MessageStream filteredInputStream = inputStream.filter((FilterFunction & Serializable)msg -> msg.getType() == OpMessage.Type.ELEMENT);
            MessageStream partitionedInputStream = !ProcessKeyedElements.needRepartition(ctx) ? filteredInputStream : filteredInputStream.partitionBy((MapFunction & Serializable)msg -> (byte[])((KV)msg.getElement().getValue()).getKey(), (MapFunction & Serializable)msg -> msg.getElement(), KVSerde.of(SamzaCoders.toSerde(kvInputCoder.getKeyCoder()), SamzaCoders.toSerde(elementCoder)), "sdf-" + SamzaPipelineTranslatorUtils.escape(ctx.getTransformId())).map((MapFunction & Serializable)kv -> OpMessage.ofElement((WindowedValue)kv.getValue()));
            MessageStream taggedOutputStream = partitionedInputStream.flatMapAsync(OpAdapter.adapt(new KvToKeyedWorkItemOp(), ctx)).flatMapAsync(OpAdapter.adapt(new SplittableParDoProcessKeyedElementsOp(transform.getMainOutputTag(), transform, windowingStrategy, new DoFnOp.MultiOutputManagerFactory(tagToIndexMap), ctx.getTransformFullName(), ctx.getTransformId(), input.isBounded()), ctx));
            Iterator iterator = tagToIndexMap.values().iterator();
            while (iterator.hasNext()) {
                int outputIndex = (Integer)iterator.next();
                MessageStream outputStream = taggedOutputStream.filter((FilterFunction & Serializable)message -> message.getType() != OpMessage.Type.ELEMENT || ((RawUnionValue)message.getElement().getValue()).getUnionTag() == outputIndex).flatMapAsync(OpAdapter.adapt(new ParDoBoundMultiTranslator.RawUnionValueToValue(), ctx));
                ctx.registerMessageStream((PValue)indexToPCollectionMap.get(outputIndex), outputStream);
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean needRepartition(@UnknownKeyFor @NonNull @Initialized TranslationContext ctx) {
            return ctx.getPipelineOptions().getMaxSourceParallelism() != 1;
        }
    }
}

