/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import org.apache.beam.sdk.util.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

public class OpMessage<@UnknownKeyFor T> {
    private final @UnknownKeyFor @NonNull @Initialized Type type;
    private final @UnknownKeyFor @NonNull @Initialized WindowedValue<T> element;
    private final @UnknownKeyFor @NonNull @Initialized String viewId;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> viewElements;
    private final @UnknownKeyFor @NonNull @Initialized Instant sideInputWatermark;

    public static <T> @UnknownKeyFor @NonNull @Initialized OpMessage<T> ofElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> element) {
        return new OpMessage<T>(Type.ELEMENT, element, null, null, null);
    }

    public static <T, ElemT> @UnknownKeyFor @NonNull @Initialized OpMessage<T> ofSideInput(@UnknownKeyFor @NonNull @Initialized String viewId, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<ElemT>> elements) {
        return new OpMessage<T>(Type.SIDE_INPUT, null, viewId, elements, null);
    }

    public static <T, ElemT> @UnknownKeyFor @NonNull @Initialized OpMessage<T> ofSideInputWatermark(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
        return new OpMessage<T>(Type.SIDE_INPUT_WATERMARK, null, null, null, watermark);
    }

    private OpMessage(@UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> element, @UnknownKeyFor @NonNull @Initialized String viewId, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> viewElements, @UnknownKeyFor @NonNull @Initialized Instant sideInputWatermark) {
        this.type = type;
        this.element = element;
        this.viewId = viewId;
        this.viewElements = viewElements;
        this.sideInputWatermark = sideInputWatermark;
    }

    public @UnknownKeyFor @NonNull @Initialized Type getType() {
        return this.type;
    }

    public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> getElement() {
        this.ensureType(Type.ELEMENT, "getElement");
        return this.element;
    }

    public @UnknownKeyFor @NonNull @Initialized String getViewId() {
        this.ensureType(Type.SIDE_INPUT, "getViewId");
        return this.viewId;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> getViewElements() {
        this.ensureType(Type.SIDE_INPUT, "getViewElements");
        return this.viewElements;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getSideInputWatermark() {
        return this.sideInputWatermark;
    }

    private void ensureType(@UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized String method) {
        if (this.type != type) {
            throw new IllegalStateException(String.format("Calling %s requires type %s, but was type %s", new Object[]{method, type, this.type}));
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpMessage opMessage = (OpMessage)o;
        if (this.type != opMessage.type) {
            return false;
        }
        if (this.element != null ? !this.element.equals(opMessage.element) : opMessage.element != null) {
            return false;
        }
        if (this.viewId != null ? !this.viewId.equals(opMessage.viewId) : opMessage.viewId != null) {
            return false;
        }
        return this.viewElements != null ? this.viewElements.equals(opMessage.viewElements) : opMessage.viewElements == null;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.element != null ? this.element.hashCode() : 0);
        result = 31 * result + (this.viewId != null ? this.viewId.hashCode() : 0);
        result = 31 * result + (this.viewElements != null ? this.viewElements.hashCode() : 0);
        return result;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "OpMessage{type=" + (Object)((Object)this.type) + ", element=" + this.element + ", viewId='" + this.viewId + '\'' + ", viewElements=" + this.viewElements + '}';
    }

    public static enum Type {
        ELEMENT,
        SIDE_INPUT,
        SIDE_INPUT_WATERMARK;

    }
}

