/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.samza.Partition;
import org.apache.samza.config.Config;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SamzaImpulseSystemFactory
implements SystemFactory {
    private static final @UnknownKeyFor @NonNull @Initialized String DUMMY_OFFSET = "0";

    public @UnknownKeyFor @NonNull @Initialized SystemConsumer getConsumer(@UnknownKeyFor @NonNull @Initialized String systemName, @UnknownKeyFor @NonNull @Initialized Config config, @UnknownKeyFor @NonNull @Initialized MetricsRegistry metricsRegistry) {
        return new SamzaImpulseSystemConsumer();
    }

    public @UnknownKeyFor @NonNull @Initialized SystemProducer getProducer(@UnknownKeyFor @NonNull @Initialized String systemName, @UnknownKeyFor @NonNull @Initialized Config config, @UnknownKeyFor @NonNull @Initialized MetricsRegistry metricsRegistry) {
        throw new UnsupportedOperationException("SamzaImpulseSystem doesn't support producing");
    }

    public @UnknownKeyFor @NonNull @Initialized SystemAdmin getAdmin(@UnknownKeyFor @NonNull @Initialized String systemName, @UnknownKeyFor @NonNull @Initialized Config config) {
        return new SamzaImpulseSystemAdmin();
    }

    public static class SamzaImpulseSystemConsumer
    implements SystemConsumer {
        private @UnknownKeyFor @NonNull @Initialized AtomicBoolean isEnd = new AtomicBoolean(false);

        public void start() {
        }

        public void stop() {
        }

        public void register(@UnknownKeyFor @NonNull @Initialized SystemStreamPartition ssp, @UnknownKeyFor @NonNull @Initialized String offset) {
        }

        private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized IncomingMessageEnvelope> constructMessages(@UnknownKeyFor @NonNull @Initialized SystemStreamPartition ssp) {
            IncomingMessageEnvelope impulseMessage = new IncomingMessageEnvelope(ssp, SamzaImpulseSystemFactory.DUMMY_OFFSET, null, OpMessage.ofElement(WindowedValue.valueInGlobalWindow((Object)new byte[0])));
            IncomingMessageEnvelope watermarkMessage = IncomingMessageEnvelope.buildWatermarkEnvelope((SystemStreamPartition)ssp, (long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis());
            IncomingMessageEnvelope endOfStreamMessage = IncomingMessageEnvelope.buildEndOfStreamEnvelope((SystemStreamPartition)ssp);
            return Arrays.asList(impulseMessage, watermarkMessage, endOfStreamMessage);
        }

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized IncomingMessageEnvelope>> poll(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition> ssps, @UnknownKeyFor @NonNull @Initialized long timeout) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            if (this.isEnd.compareAndSet(false, true)) {
                return ssps.stream().collect(Collectors.toMap(Function.identity(), SamzaImpulseSystemConsumer::constructMessages));
            }
            return Collections.emptyMap();
        }
    }

    public static class SamzaImpulseSystemAdmin
    implements SystemAdmin {
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition, @UnknownKeyFor @NonNull @Initialized String> getOffsetsAfter(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition, @UnknownKeyFor @NonNull @Initialized String> offset) {
            return offset.keySet().stream().collect(Collectors.toMap(Function.identity(), k -> SamzaImpulseSystemFactory.DUMMY_OFFSET));
        }

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SystemStreamMetadata> getSystemStreamMetadata(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> streamNames) {
            return streamNames.stream().collect(Collectors.toMap(Function.identity(), stream -> {
                Map<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> partitionMetadata = Collections.singletonMap(new Partition(0), new SystemStreamMetadata.SystemStreamPartitionMetadata(SamzaImpulseSystemFactory.DUMMY_OFFSET, SamzaImpulseSystemFactory.DUMMY_OFFSET, SamzaImpulseSystemFactory.DUMMY_OFFSET));
                return new SystemStreamMetadata(stream, partitionMetadata);
            }));
        }

        public @UnknownKeyFor @NonNull @Initialized Integer offsetComparator(@UnknownKeyFor @NonNull @Initialized String offset1, @UnknownKeyFor @NonNull @Initialized String offset2) {
            return 0;
        }
    }
}

