/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.beam.runners.samza.SamzaExecutionEnvironment;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.samza.config.ConfigLoaderFactory;
import org.apache.samza.config.loaders.PropertiesConfigLoaderFactory;
import org.apache.samza.metrics.MetricsReporter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface SamzaPipelineOptions
extends PipelineOptions {
    @Description(value="The config file for Samza. It is *optional*. By default Samza supports properties config.Without a config file, Samza uses a default config for local execution.")
    public @UnknownKeyFor @NonNull @Initialized String getConfigFilePath();

    public void setConfigFilePath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The factory to read config file from config file path.")
    @Default.Class(value=PropertiesConfigLoaderFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ConfigLoaderFactory> getConfigLoaderFactory();

    public void setConfigLoaderFactory(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ConfigLoaderFactory> var1);

    @Description(value="The config override to set programmatically. It will be applied on top of config file if it exits, otherwise used directly as the config.")
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getConfigOverride();

    public void setConfigOverride(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="The instance name of the job")
    @Default.String(value="1")
    public @UnknownKeyFor @NonNull @Initialized String getJobInstance();

    public void setJobInstance(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Samza application execution environment.See {@link org.apache.beam.runners.samza.SamzaExecutionEnvironment} for detailed environment descriptions.")
    @Default.Enum(value="LOCAL")
    public @UnknownKeyFor @NonNull @Initialized SamzaExecutionEnvironment getSamzaExecutionEnvironment();

    public void setSamzaExecutionEnvironment(@UnknownKeyFor @NonNull @Initialized SamzaExecutionEnvironment var1);

    @Description(value="The interval to check for watermarks in milliseconds.")
    @Default.Long(value=1000L)
    public @UnknownKeyFor @NonNull @Initialized long getWatermarkInterval();

    public void setWatermarkInterval(@UnknownKeyFor @NonNull @Initialized long var1);

    @Description(value="The maximum number of messages to buffer for a given system.")
    @Default.Integer(value=5000)
    public @UnknownKeyFor @NonNull @Initialized int getSystemBufferSize();

    public void setSystemBufferSize(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The maximum number of event-time timers to buffer in memory for a PTransform")
    @Default.Integer(value=50000)
    public @UnknownKeyFor @NonNull @Initialized int getEventTimerBufferSize();

    public void setEventTimerBufferSize(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The maximum number of ready timers to process at once per watermark.")
    @Default.Integer(value=0x7FFFFFFF)
    public @UnknownKeyFor @NonNull @Initialized int getMaxReadyTimersToProcessOnce();

    public void setMaxReadyTimersToProcessOnce(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The maximum parallelism allowed for any data source.")
    @Default.Integer(value=1)
    public @UnknownKeyFor @NonNull @Initialized int getMaxSourceParallelism();

    public void setMaxSourceParallelism(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The batch get size limit for the state store.")
    @Default.Integer(value=10000)
    public @UnknownKeyFor @NonNull @Initialized int getStoreBatchGetSize();

    public void setStoreBatchGetSize(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Enable/disable Beam metrics in Samza Runner")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized Boolean getEnableMetrics();

    public void setEnableMetrics(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Enable/disable Beam Transform throughput, latency metrics in Samza Runner")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getEnableTransformMetrics();

    public void setEnableTransformMetrics(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="The config for state to be durable")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getStateDurable();

    public void setStateDurable(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @JsonIgnore
    @Description(value="The metrics reporters that will be used to emit metrics.")
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetricsReporter> getMetricsReporters();

    public void setMetricsReporters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetricsReporter> var1);

    @Description(value="The maximum number of elements in a bundle.")
    @Default.Long(value=1L)
    public @UnknownKeyFor @NonNull @Initialized long getMaxBundleSize();

    public void setMaxBundleSize(@UnknownKeyFor @NonNull @Initialized long var1);

    @Description(value="The maximum time to wait before finalising a bundle (in milliseconds).")
    @Default.Long(value=1000L)
    public @UnknownKeyFor @NonNull @Initialized long getMaxBundleTimeMs();

    public void setMaxBundleTimeMs(@UnknownKeyFor @NonNull @Initialized long var1);

    @Description(value="Wait if necessary for completing a remote bundle processing for at most the given time (in milliseconds). if the value of timeout is negative, wait forever until the bundle processing is completed. Used only in portable mode for now.")
    @Default.Long(value=-1L)
    public @UnknownKeyFor @NonNull @Initialized long getBundleProcessingTimeout();

    public void setBundleProcessingTimeout(@UnknownKeyFor @NonNull @Initialized long var1);

    @Description(value="The number of threads to run DoFn.processElements in parallel within a bundle. Used only in non-portable mode.")
    @Default.Integer(value=1)
    public @UnknownKeyFor @NonNull @Initialized int getNumThreadsForProcessElement();

    public void setNumThreadsForProcessElement(@UnknownKeyFor @NonNull @Initialized int var1);

    @JsonIgnore
    @Description(value="The ExecutorService instance to run DoFN.processElements in parallel within a bundle. Used only in non-portable mode.")
    @Default.InstanceFactory(value=ProcessElementExecutorServiceFactory.class)
    @Hidden
    public @UnknownKeyFor @NonNull @Initialized ExecutorService getExecutorServiceForProcessElement();

    public void setExecutorServiceForProcessElement(@UnknownKeyFor @NonNull @Initialized ExecutorService var1);

    public static class ProcessElementExecutorServiceFactory
    implements DefaultValueFactory<ExecutorService> {
        public @UnknownKeyFor @NonNull @Initialized ExecutorService create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return Executors.newFixedThreadPool(((SamzaPipelineOptions)options.as(SamzaPipelineOptions.class)).getNumThreadsForProcessElement(), new ThreadFactoryBuilder().setNameFormat("Process Element Thread-%d").build());
        }
    }
}

