/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.Metric;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SamzaMetricsContainer {
    private static final @UnknownKeyFor @NonNull @Initialized String BEAM_METRICS_GROUP = "BeamMetrics";
    private final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap metricsContainers = new MetricsContainerStepMap();
    private final @UnknownKeyFor @NonNull @Initialized MetricsRegistryMap metricsRegistry;

    public SamzaMetricsContainer(@UnknownKeyFor @NonNull @Initialized MetricsRegistryMap metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        this.metricsRegistry.metrics().put(BEAM_METRICS_GROUP, new ConcurrentHashMap());
    }

    public @UnknownKeyFor @NonNull @Initialized MetricsContainer getContainer(@UnknownKeyFor @NonNull @Initialized String stepName) {
        return this.metricsContainers.getContainer(stepName);
    }

    public @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap getContainers() {
        return this.metricsContainers;
    }

    public void updateMetrics(@UnknownKeyFor @NonNull @Initialized String stepName) {
        assert (this.metricsRegistry != null);
        MetricResults metricResults = MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.metricsContainers);
        MetricQueryResults results = metricResults.queryMetrics(MetricsFilter.builder().addStep(stepName).build());
        CounterUpdater updateCounter = new CounterUpdater();
        results.getCounters().forEach(updateCounter);
        GaugeUpdater updateGauge = new GaugeUpdater();
        results.getGauges().forEach(updateGauge);
    }

    public void updateExecutableStageBundleMetric(@UnknownKeyFor @NonNull @Initialized String metricName, @UnknownKeyFor @NonNull @Initialized long time) {
        Gauge gauge = (Gauge)this.getSamzaMetricFor(metricName);
        if (gauge == null) {
            gauge = this.metricsRegistry.newGauge(BEAM_METRICS_GROUP, metricName, (Object)0L);
        }
        gauge.set((Object)time);
    }

    private @UnknownKeyFor @NonNull @Initialized Metric getSamzaMetricFor(@UnknownKeyFor @NonNull @Initialized String metricName) {
        return (Metric)this.metricsRegistry.getGroup(BEAM_METRICS_GROUP).get(metricName);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getMetricName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> metricResult) {
        return metricResult.getKey().toString();
    }

    private class GaugeUpdater
    implements Consumer<MetricResult<GaugeResult>> {
        private GaugeUpdater() {
        }

        @Override
        public void accept(@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult> metricResult) {
            String metricName = SamzaMetricsContainer.getMetricName(metricResult);
            Gauge gauge = (Gauge)SamzaMetricsContainer.this.getSamzaMetricFor(metricName);
            if (gauge == null) {
                gauge = SamzaMetricsContainer.this.metricsRegistry.newGauge(SamzaMetricsContainer.BEAM_METRICS_GROUP, metricName, (Object)0L);
            }
            gauge.set((Object)((GaugeResult)metricResult.getAttempted()).getValue());
        }
    }

    private class CounterUpdater
    implements Consumer<MetricResult<Long>> {
        private CounterUpdater() {
        }

        @Override
        public void accept(@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long> metricResult) {
            String metricName = SamzaMetricsContainer.getMetricName(metricResult);
            Counter counter = (Counter)SamzaMetricsContainer.this.getSamzaMetricFor(metricName);
            if (counter == null) {
                counter = SamzaMetricsContainer.this.metricsRegistry.newCounter(SamzaMetricsContainer.BEAM_METRICS_GROUP, metricName);
            }
            counter.dec(counter.getCount());
            counter.inc(((Long)metricResult.getAttempted()).longValue());
        }
    }
}

