/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental
public class PipelineJsonRenderer
implements Pipeline.PipelineVisitor {
    private static final @UnknownKeyFor @NonNull @Initialized String OUTERMOST_NODE = "OuterMostNode";
    @Nullable
    private static final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SamzaIOInfo SAMZA_IO_INFO = PipelineJsonRenderer.loadSamzaIOInfo();
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder jsonBuilder = new StringBuilder();
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder graphLinks = new StringBuilder();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized String> valueToProducerNodeName = new HashMap<PValue, String>();
    private @UnknownKeyFor @NonNull @Initialized int indent;

    public static @UnknownKeyFor @NonNull @Initialized String toJsonString(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        PipelineJsonRenderer visitor = new PipelineJsonRenderer();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        return visitor.jsonBuilder.toString();
    }

    @DoNotCall(value="JSON DAG for portable pipeline is not supported yet.")
    public static @UnknownKeyFor @NonNull @Initialized String toJsonString(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        throw new UnsupportedOperationException("JSON DAG for portable pipeline is not supported yet.");
    }

    private PipelineJsonRenderer() {
    }

    @Nullable
    private static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SamzaIOInfo loadSamzaIOInfo() {
        Iterator<SamzaIORegistrar> beamIORegistrarIterator = ServiceLoader.load(SamzaIORegistrar.class).iterator();
        return beamIORegistrarIterator.hasNext() ? ((SamzaIORegistrar)Iterators.getOnlyElement(beamIORegistrarIterator)).getSamzaIO() : null;
    }

    public void enterPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        this.writeLine("{ \n \"RootNode\": [", new Object[0]);
        this.graphLinks.append(",\"graphLinks\": [");
        this.enterBlock();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        Optional<String> ioInfo;
        String fullName = node.getFullName();
        this.writeLine("{ \"fullName\":\"%s\",", this.assignNodeName(fullName));
        if (node.getEnclosingNode() != null) {
            String enclosingNodeName = node.getEnclosingNode().getFullName();
            this.writeLine("  \"enclosingNode\":\"%s\",", this.assignNodeName(enclosingNodeName));
        }
        if ((ioInfo = this.getIOInfo(node)).isPresent() && !ioInfo.get().isEmpty()) {
            this.writeLine(" \"ioInfo\":\"%s\",", PipelineJsonRenderer.escapeString(ioInfo.get()));
        }
        this.writeLine("  \"ChildNodes\":[", new Object[0]);
        this.enterBlock();
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        this.exitBlock();
        this.writeLine("]},", new Object[0]);
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        String fullName = node.getFullName();
        this.writeLine("{ \"fullName\":\"%s\",", PipelineJsonRenderer.escapeString(fullName));
        String enclosingNodeName = node.getEnclosingNode().getFullName();
        this.writeLine("  \"enclosingNode\":\"%s\"},", this.assignNodeName(enclosingNodeName));
        node.getOutputs().values().forEach(x -> this.valueToProducerNodeName.put((PValue)x, fullName));
        node.getInputs().forEach((key, value) -> {
            String producerName = this.valueToProducerNodeName.get(value);
            this.graphLinks.append(String.format("{\"from\":\"%s\",\"to\":\"%s\"},", producerName, fullName));
        });
    }

    public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
    }

    public void leavePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this.exitBlock();
        this.writeLine("]", new Object[0]);
        int lastIndex = this.graphLinks.length() - 1;
        if (this.graphLinks.charAt(lastIndex) == ',') {
            this.graphLinks.deleteCharAt(lastIndex);
        }
        this.graphLinks.append("]");
        this.jsonBuilder.append((CharSequence)this.graphLinks);
        this.jsonBuilder.append("}");
    }

    private void enterBlock() {
        this.indent += 4;
    }

    private void exitBlock() {
        this.indent -= 4;
    }

    @FormatMethod
    private void writeLine(@FormatString @UnknownKeyFor @NonNull @Initialized String format, Object ... args) {
        int secondLastCharIndex = this.jsonBuilder.length() - 2;
        if (this.jsonBuilder.length() > 1 && this.jsonBuilder.charAt(secondLastCharIndex) == ',' && (format.startsWith("}") || format.startsWith("]"))) {
            this.jsonBuilder.deleteCharAt(secondLastCharIndex);
        }
        if (this.indent != 0) {
            this.jsonBuilder.append(String.format("%-" + this.indent + "s", ""));
        }
        this.jsonBuilder.append(String.format(format, args));
        this.jsonBuilder.append("\n");
    }

    private static @UnknownKeyFor @NonNull @Initialized String escapeString(@UnknownKeyFor @NonNull @Initialized String x) {
        return x.replace("\"", "\\\"");
    }

    private @UnknownKeyFor @NonNull @Initialized String assignNodeName(@UnknownKeyFor @NonNull @Initialized String nodeName) {
        return PipelineJsonRenderer.escapeString(nodeName.isEmpty() ? OUTERMOST_NODE : nodeName);
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getIOInfo(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        if (SAMZA_IO_INFO == null) {
            return Optional.empty();
        }
        return SAMZA_IO_INFO.getIOInfo(node);
    }

    public static interface SamzaIORegistrar {
        public @UnknownKeyFor @NonNull @Initialized SamzaIOInfo getSamzaIO();
    }

    @Experimental
    public static interface SamzaIOInfo {
        public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getIOInfo(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var1);
    }
}

