/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.util.Set;
import org.apache.beam.runners.samza.util.SamzaPipelineTranslatorUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StoreIdGenerator {
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> nonUniqueStateIds;

    public StoreIdGenerator(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> nonUniqueStateId) {
        this.nonUniqueStateIds = nonUniqueStateId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getId(@UnknownKeyFor @NonNull @Initialized String stateId, @UnknownKeyFor @NonNull @Initialized String transformFullName) {
        String storeId = stateId;
        if (this.nonUniqueStateIds.contains(stateId)) {
            String escapedName = SamzaPipelineTranslatorUtils.escape(transformFullName);
            storeId = StoreIdGenerator.toUniqueStoreId(stateId, escapedName);
        }
        return storeId;
    }

    private static @UnknownKeyFor @NonNull @Initialized String toUniqueStoreId(@UnknownKeyFor @NonNull @Initialized String stateId, @UnknownKeyFor @NonNull @Initialized String escapedPTransformName) {
        return String.join((CharSequence)"-", stateId, escapedPTransformName);
    }
}

