/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.samza.serializers.Serde;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SamzaCoders {
    private SamzaCoders() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection) {
        Coder coder = pCollection.getCoder();
        Coder windowCoder = pCollection.getWindowingStrategy().getWindowFn().windowCoder();
        return WindowedValue.FullWindowedValueCoder.of((Coder)coder, (Coder)windowCoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Serde<T> toSerde(final @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return new Serde<T>(){

            public T fromBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
                if (bytes != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    try {
                        return coder.decode((InputStream)bais);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }

            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toBytes(T t) {
                if (t != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        coder.encode(t, (OutputStream)baos);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return baos.toByteArray();
                }
                return null;
            }
        };
    }
}

