/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.runners.fnexecution.control.OutputReceiverFactory;
import org.apache.beam.runners.fnexecution.control.RemoteBundle;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.control.TimerReceiverFactory;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.runners.samza.SamzaExecutionContext;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.metrics.DoFnRunnerWithMetrics;
import org.apache.beam.runners.samza.runtime.AsyncDoFnRunner;
import org.apache.beam.runners.samza.runtime.DoFnRunnerWithKeyedInternals;
import org.apache.beam.runners.samza.runtime.FutureCollector;
import org.apache.beam.runners.samza.runtime.KeyedInternals;
import org.apache.beam.runners.samza.runtime.OpEmitter;
import org.apache.beam.runners.samza.runtime.SamzaStateRequestHandlers;
import org.apache.beam.runners.samza.runtime.SamzaStoreStateInternals;
import org.apache.beam.runners.samza.runtime.SamzaTimerInternalsFactory;
import org.apache.beam.runners.samza.util.StateUtils;
import org.apache.beam.runners.samza.util.WindowUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.samza.context.Context;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class SamzaDoFnRunners {
    public static <InT, FnOutT> @UnknownKeyFor @NonNull @Initialized DoFnRunner<InT, FnOutT> create(@UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized DoFn<InT, FnOutT> doFn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized String transformFullName, @UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized TupleTag<FnOutT> mainOutputTag, @UnknownKeyFor @NonNull @Initialized SideInputHandler sideInputHandler, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SamzaTimerInternalsFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> timerInternalsFactory, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager outputManager, @UnknownKeyFor @NonNull @Initialized Coder<InT> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideOutputTags, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> stateIdToStoreIdMapping, @UnknownKeyFor @NonNull @Initialized OpEmitter emitter, @UnknownKeyFor @NonNull @Initialized FutureCollector futureCollector) {
        DoFnRunner doFnRunnerWithStates;
        DoFnRunner doFnRunnerWithMetrics;
        TimerInternals timerInternals;
        StateInternals stateInternals;
        KeyedInternals keyedInternals;
        SamzaStoreStateInternals.Factory<?> stateInternalsFactory = SamzaStoreStateInternals.createStateInternalsFactory(transformId, keyCoder, context.getTaskContext(), pipelineOptions, stateIdToStoreIdMapping);
        SamzaExecutionContext executionContext = (SamzaExecutionContext)context.getApplicationContainerContext();
        if (StateUtils.isStateful(doFn)) {
            keyedInternals = new KeyedInternals(stateInternalsFactory, timerInternalsFactory);
            stateInternals = keyedInternals.stateInternals();
            timerInternals = keyedInternals.timerInternals();
        } else {
            keyedInternals = null;
            stateInternals = stateInternalsFactory.stateInternalsForKey(null);
            timerInternals = timerInternalsFactory.timerInternalsForKey(null);
        }
        StepContext stepContext = SamzaDoFnRunners.createStepContext(stateInternals, timerInternals);
        DoFnRunner underlyingRunner = DoFnRunners.simpleRunner((PipelineOptions)pipelineOptions, doFn, (SideInputReader)sideInputHandler, (DoFnRunners.OutputManager)outputManager, mainOutputTag, sideOutputTags, (StepContext)stepContext, inputCoder, outputCoders, windowingStrategy, (DoFnSchemaInformation)doFnSchemaInformation, sideInputMapping);
        DoFnRunner doFnRunner = doFnRunnerWithMetrics = pipelineOptions.getEnableMetrics() != false ? DoFnRunnerWithMetrics.wrap(underlyingRunner, executionContext.getMetricsContainer(), transformFullName) : underlyingRunner;
        if (keyedInternals != null) {
            DoFnRunner statefulDoFnRunner = DoFnRunners.defaultStatefulDoFnRunner(doFn, inputCoder, doFnRunnerWithMetrics, (StepContext)stepContext, windowingStrategy, (StatefulDoFnRunner.CleanupTimer)new StatefulDoFnRunner.TimeInternalsCleanupTimer(timerInternals, windowingStrategy), SamzaDoFnRunners.createStateCleaner(doFn, windowingStrategy, keyedInternals.stateInternals()));
            doFnRunnerWithStates = new DoFnRunnerWithKeyedInternals(statefulDoFnRunner, keyedInternals);
        } else {
            doFnRunnerWithStates = doFnRunnerWithMetrics;
        }
        return pipelineOptions.getNumThreadsForProcessElement() > 1 ? AsyncDoFnRunner.create(doFnRunnerWithStates, emitter, futureCollector, keyedInternals != null, pipelineOptions) : doFnRunnerWithStates;
    }

    private static @UnknownKeyFor @NonNull @Initialized StepContext createStepContext(final @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals, final @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals) {
        return new StepContext(){

            public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals() {
                return stateInternals;
            }

            public @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals() {
                return timerInternals;
            }
        };
    }

    private static <InT, FnOutT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized StatefulDoFnRunner.StateCleaner<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> createStateCleaner(@UnknownKeyFor @NonNull @Initialized DoFn<InT, FnOutT> doFn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals) {
        TypeDescriptor windowType = windowingStrategy.getWindowFn().getWindowTypeDescriptor();
        if (windowType.isSubtypeOf(TypeDescriptor.of(BoundedWindow.class))) {
            Coder windowCoder = windowingStrategy.getWindowFn().windowCoder();
            return new StatefulDoFnRunner.StateInternalsStateCleaner(doFn, stateInternals, windowCoder);
        }
        return null;
    }

    public static <InT, FnOutT> @UnknownKeyFor @NonNull @Initialized DoFnRunner<InT, FnOutT> createPortable(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized String bundleStateId, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>> windowedValueCoder, @UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping, @UnknownKeyFor @NonNull @Initialized SideInputHandler sideInputHandler, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SamzaStoreStateInternals.Factory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> nonKeyedStateInternalsFactory, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SamzaTimerInternalsFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> timerInternalsFactory, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager outputManager, @UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory, @UnknownKeyFor @NonNull @Initialized SamzaExecutionContext samzaExecutionContext, @UnknownKeyFor @NonNull @Initialized TupleTag<FnOutT> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> idToTupleTagMap, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized String transformFullName) {
        BagState bundledEventsBag = (BagState)nonKeyedStateInternalsFactory.stateInternalsForKey(null).state(StateNamespaces.global(), StateTags.bag((String)bundleStateId, windowedValueCoder));
        StateRequestHandler stateRequestHandler = SamzaStateRequestHandlers.of(transformId, context.getTaskContext(), pipelineOptions, executableStage, stageBundleFactory, sideInputMapping, sideInputHandler);
        SamzaExecutionContext executionContext = (SamzaExecutionContext)context.getApplicationContainerContext();
        SdkHarnessDoFnRunner underlyingRunner = new SdkHarnessDoFnRunner(stepName, timerInternalsFactory, WindowUtils.getWindowStrategy(executableStage.getInputPCollection().getId(), executableStage.getComponents()), outputManager, stageBundleFactory, idToTupleTagMap, bundledEventsBag, stateRequestHandler, samzaExecutionContext);
        return pipelineOptions.getEnableMetrics() != false ? DoFnRunnerWithMetrics.wrap(underlyingRunner, executionContext.getMetricsContainer(), transformFullName) : underlyingRunner;
    }

    private static class SdkHarnessDoFnRunner<@UnknownKeyFor InT, @UnknownKeyFor FnOutT>
    implements DoFnRunner<InT, FnOutT> {
        private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_METRIC_SAMPLE_RATE = 100;
        private final @UnknownKeyFor @NonNull @Initialized SamzaTimerInternalsFactory timerInternalsFactory;
        private final @UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager outputManager;
        private final @UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> idToTupleTagMap;
        private final @UnknownKeyFor @NonNull @Initialized LinkedBlockingQueue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, FnOutT>> outputQueue = new LinkedBlockingQueue();
        private final @UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>> bundledEventsBag;
        private @UnknownKeyFor @NonNull @Initialized RemoteBundle remoteBundle;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputReceiver;
        private final @UnknownKeyFor @NonNull @Initialized StateRequestHandler stateRequestHandler;
        private final @UnknownKeyFor @NonNull @Initialized SamzaExecutionContext samzaExecutionContext;
        private @UnknownKeyFor @NonNull @Initialized long startBundleTime;
        private final @UnknownKeyFor @NonNull @Initialized String metricName;

        private SdkHarnessDoFnRunner(@UnknownKeyFor @NonNull @Initialized String stepName, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SamzaTimerInternalsFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> timerInternalsFactory, @UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager outputManager, @UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> idToTupleTagMap, @UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>> bundledEventsBag, @UnknownKeyFor @NonNull @Initialized StateRequestHandler stateRequestHandler, @UnknownKeyFor @NonNull @Initialized SamzaExecutionContext samzaExecutionContext) {
            this.timerInternalsFactory = timerInternalsFactory;
            this.windowingStrategy = windowingStrategy;
            this.outputManager = outputManager;
            this.stageBundleFactory = stageBundleFactory;
            this.idToTupleTagMap = idToTupleTagMap;
            this.bundledEventsBag = bundledEventsBag;
            this.stateRequestHandler = stateRequestHandler;
            this.samzaExecutionContext = samzaExecutionContext;
            this.metricName = "ExecutableStage-" + stepName + "-process-ns";
        }

        private void timerDataConsumer(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Timer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> timerElement, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
            TimerInternals timerInternals = this.timerInternalsFactory.timerInternalsForKey(timerElement.getUserKey());
            if (timerElement.getClearBit()) {
                timerInternals.deleteTimer(timerData);
            } else {
                timerInternals.setTimer(timerData);
            }
        }

        public void startBundle() {
            try {
                OutputReceiverFactory receiverFactory = new OutputReceiverFactory(){

                    public @UnknownKeyFor @NonNull @Initialized FnDataReceiver<FnOutT> create(@UnknownKeyFor @NonNull @Initialized String pCollectionId) {
                        return receivedElement -> outputQueue.put(KV.of((Object)pCollectionId, (Object)receivedElement));
                    }
                };
                Coder windowCoder = this.windowingStrategy.getWindowFn().windowCoder();
                TimerReceiverFactory timerReceiverFactory = new TimerReceiverFactory(this.stageBundleFactory, this::timerDataConsumer, windowCoder);
                this.remoteBundle = this.stageBundleFactory.getBundle(receiverFactory, timerReceiverFactory, this.stateRequestHandler, BundleProgressHandler.ignored());
                this.startBundleTime = this.getStartBundleTime();
                this.inputReceiver = (FnDataReceiver)Iterables.getOnlyElement(this.remoteBundle.getInputReceivers().values());
                this.bundledEventsBag.read().forEach(elem -> {
                    try {
                        this.inputReceiver.accept(elem);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized long getStartBundleTime() {
            return ThreadLocalRandom.current().nextInt() % 100 == 0 ? System.nanoTime() : 0L;
        }

        public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InT> elem) {
            try {
                this.bundledEventsBag.add(elem);
                this.inputReceiver.accept(elem);
                this.emitResults();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void emitResults() {
            KV<String, FnOutT> result;
            while ((result = this.outputQueue.poll()) != null) {
                this.outputManager.output(this.idToTupleTagMap.get(result.getKey()), (WindowedValue)result.getValue());
            }
        }

        private void emitMetrics() {
            if (this.startBundleTime <= 0L) {
                return;
            }
            long count = Iterables.size((Iterable)this.bundledEventsBag.read());
            if (count <= 0L) {
                return;
            }
            long finishBundleTime = System.nanoTime();
            long averageProcessTime = (finishBundleTime - this.startBundleTime) / count;
            this.samzaExecutionContext.getMetricsContainer().updateExecutableStageBundleMetric(this.metricName, averageProcessTime);
        }

        public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            KV timerReceiverKey = TimerReceiverFactory.decodeTimerDataTimerId((String)timerFamilyId);
            FnDataReceiver timerReceiver = (FnDataReceiver)this.remoteBundle.getTimerReceivers().get(timerReceiverKey);
            Timer timerValue = Timer.of(key, (String)timerId, Collections.singletonList(window), (Instant)timestamp, (Instant)outputTimestamp, (PaneInfo)PaneInfo.NO_FIRING);
            try {
                timerReceiver.accept((Object)timerValue);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to process timer %s", timerReceiver), e);
            }
        }

        public void finishBundle() {
            try {
                this.remoteBundle.close();
                this.emitResults();
                this.emitMetrics();
                this.bundledEventsBag.clear();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to finish remote bundle", e);
            }
            finally {
                this.remoteBundle = null;
                this.inputReceiver = null;
            }
        }

        public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, KeyT key) {
        }

        public @UnknownKeyFor @NonNull @Initialized DoFn<InT, FnOutT> getFn() {
            throw new UnsupportedOperationException();
        }
    }
}

