/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.beam.runners.core.construction.NativeTransforms;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.runners.samza.util.SamzaCoders;
import org.apache.beam.runners.samza.util.WindowUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.serializers.KVSerde;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReshuffleTranslator<@UnknownKeyFor K, @UnknownKeyFor InT, @UnknownKeyFor OutT>
implements TransformTranslator<PTransform<PCollection<KV<K, InT>>, PCollection<KV<K, OutT>>>> {
    @Override
    public void translate(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutT>>> transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized TranslationContext ctx) {
        PCollection<KV<K, InT>> input = ctx.getInput(transform);
        PCollection<KV<K, OutT>> output = ctx.getOutput(transform);
        MessageStream inputStream = ctx.getMessageStream((PValue)input);
        KvCoder inputCoder = (KvCoder)input.getCoder();
        Coder<WindowedValue<KV<K, InT>>> elementCoder = SamzaCoders.of(input);
        MessageStream<OpMessage<KV<K, InT>>> outputStream = ReshuffleTranslator.doTranslate(inputStream, inputCoder.getKeyCoder(), elementCoder, "rshfl-" + ctx.getTransformId(), ctx.getPipelineOptions().getMaxSourceParallelism() > 1);
        ctx.registerMessageStream((PValue)output, outputStream);
    }

    @Override
    public void translatePortable(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline, @UnknownKeyFor @NonNull @Initialized PortableTranslationContext ctx) {
        String inputId = ctx.getInputId(transform);
        MessageStream inputStream = ctx.getMessageStreamById(inputId);
        WindowedValue.WindowedValueCoder windowedInputCoder = WindowUtils.instantiateWindowedCoder(inputId, pipeline.getComponents());
        String outputId = ctx.getOutputId(transform);
        MessageStream<OpMessage<KV<K, InT>>> outputStream = ReshuffleTranslator.doTranslate(inputStream, ((KvCoder)windowedInputCoder.getValueCoder()).getKeyCoder(), windowedInputCoder, "rshfl-" + ctx.getTransformId(), ctx.getPipelineOptions().getMaxSourceParallelism() > 1);
        ctx.registerMessageStream(outputId, outputStream);
    }

    private static <K, InT> @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<@UnknownKeyFor @NonNull @Initialized KV<K, InT>>> doTranslate(@UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<@UnknownKeyFor @NonNull @Initialized KV<K, InT>>> inputStream, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InT>>> valueCoder, @UnknownKeyFor @NonNull @Initialized String partitionById, @UnknownKeyFor @NonNull @Initialized boolean needRepartition) {
        return needRepartition ? inputStream.filter((FilterFunction & Serializable)op -> OpMessage.Type.ELEMENT == op.getType()).partitionBy((MapFunction & Serializable)opMessage -> ((KV)opMessage.getElement().getValue()).getKey(), OpMessage::getElement, KVSerde.of(SamzaCoders.toSerde(keyCoder), SamzaCoders.toSerde(valueCoder)), partitionById).map((MapFunction & Serializable)kv -> OpMessage.ofElement((WindowedValue)kv.getValue())) : inputStream.filter((FilterFunction & Serializable)op -> OpMessage.Type.ELEMENT == op.getType());
    }

    @AutoService(value={NativeTransforms.IsNativeTransform.class})
    public static class IsSamzaNativeTransform
    implements NativeTransforms.IsNativeTransform {
        public @UnknownKeyFor @NonNull @Initialized boolean test(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform) {
            return false;
        }
    }
}

