/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PortableTranslationContext
extends TranslationContext {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> messageStreams = new HashMap();
    private final @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode currentTransform;

    public PortableTranslationContext(@UnknownKeyFor @NonNull @Initialized StreamApplicationDescriptor appDescriptor, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions options, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        super(appDescriptor, Collections.emptyMap(), options);
        this.jobInfo = jobInfo;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<T>>> getAllInputMessageStreams(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        Collection inputStreamIds = transform.getTransform().getInputsMap().values();
        return inputStreamIds.stream().map(this::getMessageStreamById).collect(Collectors.toList());
    }

    public <T> @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<T>> getOneInputMessageStream(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        String id = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        return this.getMessageStreamById(id);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<T>> getMessageStreamById(@UnknownKeyFor @NonNull @Initialized String id) {
        return this.messageStreams.get(id);
    }

    public @UnknownKeyFor @NonNull @Initialized String getInputId(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
    }

    public @UnknownKeyFor @NonNull @Initialized String getOutputId(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values());
    }

    public @UnknownKeyFor @NonNull @Initialized JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public <T> void registerMessageStream(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized MessageStream<@UnknownKeyFor @NonNull @Initialized OpMessage<T>> stream) {
        if (this.messageStreams.containsKey(id)) {
            throw new IllegalArgumentException("Stream already registered for id: " + id);
        }
        this.messageStreams.put(id, stream);
    }

    public <T> void registerInputMessageStream(@UnknownKeyFor @NonNull @Initialized String id, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized InputDescriptor<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized OpMessage<T>>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> inputDescriptor) {
        this.registerInputMessageStreams(id, Collections.singletonList(inputDescriptor));
    }

    public <T> void registerInputMessageStreams(@UnknownKeyFor @NonNull @Initialized String id, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized InputDescriptor<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized OpMessage<T>>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> inputDescriptors) {
        this.registerInputMessageStreams(id, inputDescriptors, this::registerMessageStream);
    }

    public void setCurrentTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode currentTransform) {
        this.currentTransform = currentTransform;
    }

    @Override
    public void clearCurrentTransform() {
        this.currentTransform = null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTransformFullName() {
        return this.currentTransform.getTransform().getUniqueName();
    }
}

