/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.adapter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.serialization.Base64Serializer;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.metrics.FnWithMetricsWrapper;
import org.apache.beam.runners.samza.metrics.SamzaMetricsContainer;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundedSourceSystem {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(UnboundedSourceSystem.class);
    private static final @UnknownKeyFor @NonNull @Initialized IncomingMessageEnvelope CHECK_LAST_EXCEPTION_ENVELOPE = new IncomingMessageEnvelope(null, null, null, null);

    private static <T, CheckpointMarkT extends UnboundedSource.CheckpointMark> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT>> split(@UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> source, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
        List splits;
        int numSplits = pipelineOptions.getMaxSourceParallelism();
        if (numSplits > 1 && !(splits = source.split(numSplits, (PipelineOptions)pipelineOptions)).isEmpty()) {
            return splits;
        }
        return Collections.singletonList(source);
    }

    public static class Factory<@UnknownKeyFor T, @UnknownKeyFor CheckpointMarkT extends // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
    implements SystemFactory {
        public @UnknownKeyFor @NonNull @Initialized SystemConsumer getConsumer(@UnknownKeyFor @NonNull @Initialized String systemName, @UnknownKeyFor @NonNull @Initialized Config config, @UnknownKeyFor @NonNull @Initialized MetricsRegistry registry) {
            String streamPrefix = "systems." + systemName;
            Config scopedConfig = config.subset(streamPrefix + ".", true);
            return new Consumer<T, CheckpointMarkT>(Factory.getUnboundedSource(scopedConfig), Factory.getPipelineOptions(config), new SamzaMetricsContainer((MetricsRegistryMap)registry), (String)scopedConfig.get((Object)"stepName"));
        }

        public @UnknownKeyFor @NonNull @Initialized SystemProducer getProducer(@UnknownKeyFor @NonNull @Initialized String systemName, @UnknownKeyFor @NonNull @Initialized Config config, @UnknownKeyFor @NonNull @Initialized MetricsRegistry registry) {
            LOG.info("System " + systemName + " does not have producer.");
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized SystemAdmin getAdmin(@UnknownKeyFor @NonNull @Initialized String systemName, @UnknownKeyFor @NonNull @Initialized Config config) {
            Config scopedConfig = config.subset("systems." + systemName + ".", true);
            return new Admin<T, CheckpointMarkT>(Factory.getUnboundedSource(scopedConfig), Factory.getPipelineOptions(config));
        }

        private static <T, CheckpointMarkT extends UnboundedSource.CheckpointMark> @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> getUnboundedSource(@UnknownKeyFor @NonNull @Initialized Config config) {
            UnboundedSource source = (UnboundedSource)Base64Serializer.deserializeUnchecked((String)((String)config.get((Object)"source")), UnboundedSource.class);
            return source;
        }

        private static @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions getPipelineOptions(@UnknownKeyFor @NonNull @Initialized Config config) {
            return (SamzaPipelineOptions)((SerializablePipelineOptions)Base64Serializer.deserializeUnchecked((String)((String)config.get((Object)"beamPipelineOptions")), SerializablePipelineOptions.class)).get().as(SamzaPipelineOptions.class);
        }
    }

    public static class Consumer<@UnknownKeyFor T, @UnknownKeyFor CheckpointMarkT extends // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
    implements SystemConsumer {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Consumer.class);
        private static final @UnknownKeyFor @NonNull @Initialized AtomicInteger NEXT_ID = new AtomicInteger();
        private final @UnknownKeyFor @NonNull @Initialized Coder<CheckpointMarkT> checkpointMarkCoder;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT>> splits;
        private final @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions;
        private final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader, @UnknownKeyFor @NonNull @Initialized SystemStreamPartition> readerToSsp = new HashMap<UnboundedSource.UnboundedReader, SystemStreamPartition>();
        private final @UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer metricsContainer;
        private final @UnknownKeyFor @NonNull @Initialized String stepName;
        private @UnknownKeyFor @NonNull @Initialized ReaderTask<T, CheckpointMarkT> readerTask;

        Consumer(@UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> source, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer metricsContainer, @UnknownKeyFor @NonNull @Initialized String stepName) {
            try {
                this.splits = UnboundedSourceSystem.split(source, pipelineOptions);
            }
            catch (Exception e) {
                throw new SamzaException("Fail to split source", (Throwable)e);
            }
            this.checkpointMarkCoder = source.getCheckpointMarkCoder();
            this.pipelineOptions = pipelineOptions;
            this.metricsContainer = metricsContainer;
            this.stepName = stepName;
        }

        public void start() {
            if (this.readerToSsp.isEmpty()) {
                throw new IllegalArgumentException("Attempted to call start without assigned system stream partitions");
            }
            FnWithMetricsWrapper metricsWrapper = this.pipelineOptions.getEnableMetrics() != false ? new FnWithMetricsWrapper(this.metricsContainer, this.stepName) : null;
            this.readerTask = new ReaderTask(this.readerToSsp, this.checkpointMarkCoder, this.pipelineOptions.getSystemBufferSize(), this.pipelineOptions.getWatermarkInterval(), metricsWrapper);
            Thread thread = new Thread(this.readerTask, "unbounded-source-system-consumer-" + NEXT_ID.getAndIncrement());
            thread.start();
        }

        public void stop() {
            this.readerTask.stop();
        }

        public void register(@UnknownKeyFor @NonNull @Initialized SystemStreamPartition ssp, @UnknownKeyFor @NonNull @Initialized String offset) {
            UnboundedSource.CheckpointMark checkpoint = null;
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{offset})) {
                byte[] offsetBytes = Base64.getDecoder().decode(offset);
                ByteArrayInputStream bais = new ByteArrayInputStream(offsetBytes);
                try {
                    checkpoint = (UnboundedSource.CheckpointMark)this.checkpointMarkCoder.decode((InputStream)bais);
                }
                catch (Exception e) {
                    throw new SamzaException("Error in decode offset", (Throwable)e);
                }
            }
            int partitionId = ssp.getPartition().getPartitionId();
            try {
                UnboundedSource.UnboundedReader reader = this.splits.get(partitionId).createReader((PipelineOptions)this.pipelineOptions, checkpoint);
                this.readerToSsp.put(reader, ssp);
            }
            catch (Exception e) {
                throw new SamzaException("Error while creating source reader for ssp: " + ssp, (Throwable)e);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized IncomingMessageEnvelope>> poll(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition> systemStreamPartitions, @UnknownKeyFor @NonNull @Initialized long timeout) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            assert (!this.readerToSsp.isEmpty());
            HashMap<SystemStreamPartition, List<IncomingMessageEnvelope>> envelopes = new HashMap<SystemStreamPartition, List<IncomingMessageEnvelope>>();
            for (SystemStreamPartition ssp : systemStreamPartitions) {
                envelopes.put(ssp, this.readerTask.getNextMessages(ssp, timeout));
            }
            return envelopes;
        }

        private static class ReaderTask<@UnknownKeyFor T, @UnknownKeyFor CheckpointMarkT extends // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
        implements Runnable {
            private final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader, @UnknownKeyFor @NonNull @Initialized SystemStreamPartition> readerToSsp;
            private final @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader> readers;
            private final @UnknownKeyFor @NonNull @Initialized Coder<CheckpointMarkT> checkpointMarkCoder;
            private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition, @UnknownKeyFor @NonNull @Initialized Instant> currentWatermarks = new HashMap<SystemStreamPartition, Instant>();
            private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition, @UnknownKeyFor @NonNull @Initialized LinkedBlockingQueue<@UnknownKeyFor @NonNull @Initialized IncomingMessageEnvelope>> queues;
            private final @UnknownKeyFor @NonNull @Initialized long watermarkInterval;
            private final @UnknownKeyFor @NonNull @Initialized Semaphore available;
            private final @UnknownKeyFor @NonNull @Initialized FnWithMetricsWrapper metricsWrapper;
            private volatile @UnknownKeyFor @NonNull @Initialized boolean running;
            private volatile @UnknownKeyFor @NonNull @Initialized Exception lastException;
            private @UnknownKeyFor @NonNull @Initialized long lastWatermarkTime = 0L;

            private ReaderTask(@UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader, @UnknownKeyFor @NonNull @Initialized SystemStreamPartition> readerToSsp, @UnknownKeyFor @NonNull @Initialized Coder<CheckpointMarkT> checkpointMarkCoder, @UnknownKeyFor @NonNull @Initialized int capacity, @UnknownKeyFor @NonNull @Initialized long watermarkInterval, @UnknownKeyFor @NonNull @Initialized FnWithMetricsWrapper metricsWrapper) {
                this.readerToSsp = readerToSsp;
                this.checkpointMarkCoder = checkpointMarkCoder;
                this.readers = ImmutableList.copyOf(readerToSsp.keySet());
                this.watermarkInterval = watermarkInterval;
                this.available = new Semaphore(capacity);
                this.metricsWrapper = metricsWrapper;
                HashMap qs = new HashMap();
                readerToSsp.values().forEach(ssp -> qs.put(ssp, new LinkedBlockingQueue()));
                this.queues = ImmutableMap.copyOf(qs);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.running = true;
                try {
                    for (UnboundedSource.UnboundedReader reader2 : this.readers) {
                        boolean hasData = this.invoke(() -> ((UnboundedSource.UnboundedReader)reader2).start());
                        if (!hasData) continue;
                        this.available.acquire();
                        this.enqueueMessage(reader2);
                    }
                    while (this.running) {
                        boolean elementAvailable = false;
                        for (UnboundedSource.UnboundedReader reader3 : this.readers) {
                            boolean hasData = this.invoke(() -> ((UnboundedSource.UnboundedReader)reader3).advance());
                            if (!hasData) continue;
                            while (!this.available.tryAcquire(1, Math.max(this.lastWatermarkTime + this.watermarkInterval - System.currentTimeMillis(), 1L), TimeUnit.MILLISECONDS)) {
                                this.updateWatermark();
                            }
                            this.enqueueMessage(reader3);
                            elementAvailable = true;
                        }
                        this.updateWatermark();
                        if (elementAvailable) continue;
                        Thread.sleep(50L);
                    }
                }
                catch (Exception e) {
                    this.lastException = e;
                    this.running = false;
                }
                finally {
                    this.readers.forEach(reader -> {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LOG.error("Reader task failed to close reader", (Throwable)e);
                        }
                    });
                }
                if (this.lastException != null) {
                    this.queues.values().forEach(queue -> {
                        queue.clear();
                        queue.add(CHECK_LAST_EXCEPTION_ENVELOPE);
                    });
                }
            }

            private <X> X invoke(@UnknownKeyFor @NonNull @Initialized FnWithMetricsWrapper.SupplierWithException<X> fn) throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (this.metricsWrapper != null) {
                    return this.metricsWrapper.wrap(fn, true);
                }
                return fn.get();
            }

            private void updateWatermark() throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
                long time = System.currentTimeMillis();
                if (time - this.lastWatermarkTime > this.watermarkInterval) {
                    for (UnboundedSource.UnboundedReader reader : this.readers) {
                        Instant nextWatermark;
                        SystemStreamPartition ssp = this.readerToSsp.get(reader);
                        Instant currentWatermark = this.currentWatermarks.containsKey(ssp) ? this.currentWatermarks.get(ssp) : BoundedWindow.TIMESTAMP_MIN_VALUE;
                        if (!currentWatermark.isBefore((ReadableInstant)(nextWatermark = reader.getWatermark()))) continue;
                        this.currentWatermarks.put(ssp, nextWatermark);
                        if (BoundedWindow.TIMESTAMP_MAX_VALUE.isAfter((ReadableInstant)nextWatermark)) {
                            this.enqueueWatermark(reader);
                            continue;
                        }
                        this.enqueueMaxWatermarkAndEndOfStream(reader);
                        this.running = false;
                    }
                    this.lastWatermarkTime = time;
                }
            }

            private void enqueueWatermark(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader reader) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
                SystemStreamPartition ssp = this.readerToSsp.get(reader);
                IncomingMessageEnvelope envelope = IncomingMessageEnvelope.buildWatermarkEnvelope((SystemStreamPartition)ssp, (long)reader.getWatermark().getMillis());
                this.queues.get(ssp).put(envelope);
            }

            private void enqueueMessage(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader reader) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
                Object value = reader.getCurrent();
                Instant time = reader.getCurrentTimestamp();
                SystemStreamPartition ssp = this.readerToSsp.get(reader);
                WindowedValue windowedValue = WindowedValue.timestampedValueInGlobalWindow((Object)value, (Instant)time);
                OpMessage opMessage = OpMessage.ofElement(windowedValue);
                IncomingMessageEnvelope envelope = new IncomingMessageEnvelope(ssp, this.getOffset(reader), null, opMessage);
                this.queues.get(ssp).put(envelope);
            }

            private void enqueueMaxWatermarkAndEndOfStream(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<T> reader) {
                SystemStreamPartition ssp = this.readerToSsp.get(reader);
                IncomingMessageEnvelope watermarkEnvelope = IncomingMessageEnvelope.buildWatermarkEnvelope((SystemStreamPartition)ssp, (long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis());
                this.enqueueUninterruptibly(watermarkEnvelope);
                IncomingMessageEnvelope endOfStreamEnvelope = IncomingMessageEnvelope.buildEndOfStreamEnvelope((SystemStreamPartition)ssp);
                this.enqueueUninterruptibly(endOfStreamEnvelope);
            }

            private void enqueueUninterruptibly(@UnknownKeyFor @NonNull @Initialized IncomingMessageEnvelope envelope) {
                BlockingQueue queue = this.queues.get(envelope.getSystemStreamPartition());
                while (true) {
                    try {
                        queue.put(envelope);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }

            void stop() {
                this.running = false;
            }

            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized IncomingMessageEnvelope> getNextMessages(@UnknownKeyFor @NonNull @Initialized SystemStreamPartition ssp, @UnknownKeyFor @NonNull @Initialized long timeoutMillis) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
                if (this.lastException != null) {
                    throw new RuntimeException(this.lastException);
                }
                ArrayList<IncomingMessageEnvelope> envelopes = new ArrayList<IncomingMessageEnvelope>();
                BlockingQueue queue = this.queues.get(ssp);
                IncomingMessageEnvelope envelope = (IncomingMessageEnvelope)queue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
                if (envelope != null) {
                    envelopes.add(envelope);
                    queue.drainTo(envelopes);
                }
                int numElements = (int)envelopes.stream().filter(ev -> ev.getMessage() instanceof OpMessage).count();
                this.available.release(numElements);
                if (this.lastException != null) {
                    throw new RuntimeException(this.lastException);
                }
                return envelopes;
            }

            private @UnknownKeyFor @NonNull @Initialized String getOffset(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader reader) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    UnboundedSource.CheckpointMark checkpointMark = this.invoke(() -> ((UnboundedSource.UnboundedReader)reader).getCheckpointMark());
                    this.checkpointMarkCoder.encode((Object)checkpointMark, (OutputStream)baos);
                    return Base64.getEncoder().encodeToString(baos.toByteArray());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class Admin<@UnknownKeyFor T, @UnknownKeyFor CheckpointMarkT extends // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
    implements SystemAdmin {
        private final @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> source;
        private final @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions;

        public Admin(@UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> source, @UnknownKeyFor @NonNull @Initialized SamzaPipelineOptions pipelineOptions) {
            this.source = source;
            this.pipelineOptions = pipelineOptions;
        }

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition, @UnknownKeyFor @NonNull @Initialized String> getOffsetsAfter(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized SystemStreamPartition, @UnknownKeyFor @NonNull @Initialized String> offsets) {
            return offsets;
        }

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SystemStreamMetadata> getSystemStreamMetadata(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> streamNames) {
            return streamNames.stream().collect(Collectors.toMap(Function.identity(), streamName -> {
                try {
                    List splits = UnboundedSourceSystem.split(this.source, this.pipelineOptions);
                    HashMap<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> partitionMetaData = new HashMap<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata>();
                    for (int i = 0; i < splits.size(); ++i) {
                        partitionMetaData.put(new Partition(i), new SystemStreamMetadata.SystemStreamPartitionMetadata(null, null, null));
                    }
                    return new SystemStreamMetadata(streamName, partitionMetaData);
                }
                catch (Exception e) {
                    throw new SamzaException("Fail to read stream metadata", (Throwable)e);
                }
            }));
        }

        public @UnknownKeyFor @NonNull @Initialized Integer offsetComparator(@UnknownKeyFor @NonNull @Initialized String offset1, @UnknownKeyFor @NonNull @Initialized String offset2) {
            return null;
        }
    }
}

