/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.samza.SamzaExecutionContext;
import org.apache.beam.runners.samza.SamzaPipelineLifeCycleListener;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.samza.config.Config;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.runtime.ApplicationRunner;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaPipelineResult
implements PipelineResult {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SamzaPipelineResult.class);
    private static final @UnknownKeyFor @NonNull @Initialized long SHUTDOWN_TIMEOUT_BUFFER = 5000L;
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_TASK_SHUTDOWN_MS = 30000L;
    private final @UnknownKeyFor @NonNull @Initialized SamzaExecutionContext executionContext;
    private final @UnknownKeyFor @NonNull @Initialized ApplicationRunner runner;
    private final @UnknownKeyFor @NonNull @Initialized SamzaPipelineLifeCycleListener listener;
    private final @UnknownKeyFor @NonNull @Initialized long shutdownTiemoutMs;

    public SamzaPipelineResult(@UnknownKeyFor @NonNull @Initialized ApplicationRunner runner, @UnknownKeyFor @NonNull @Initialized SamzaExecutionContext executionContext, @UnknownKeyFor @NonNull @Initialized SamzaPipelineLifeCycleListener listener, @UnknownKeyFor @NonNull @Initialized Config config) {
        this.executionContext = executionContext;
        this.runner = runner;
        this.listener = listener;
        this.shutdownTiemoutMs = config.getLong("task.shutdown.ms", 30000L) + 5000L;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State getState() {
        return this.getStateInfo().state;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State cancel() {
        LOG.info("Start to cancel samza pipeline...");
        this.runner.kill();
        LOG.info("Start awaiting finish for {} ms.", (Object)this.shutdownTiemoutMs);
        return this.waitUntilFinish(Duration.millis((long)this.shutdownTiemoutMs));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish(@Nullable @UnknownKeyFor @Initialized Duration duration) {
        try {
            if (duration == null) {
                this.runner.waitForFinish();
            } else {
                this.runner.waitForFinish(java.time.Duration.ofMillis(duration.getMillis()));
            }
        }
        catch (Exception e) {
            throw new Pipeline.PipelineExecutionException((Throwable)e);
        }
        StateInfo stateInfo = this.getStateInfo();
        if (this.listener != null && (stateInfo.state == PipelineResult.State.DONE || stateInfo.state == PipelineResult.State.FAILED)) {
            this.listener.onFinish();
        }
        if (stateInfo.state == PipelineResult.State.FAILED) {
            throw stateInfo.error;
        }
        LOG.info("Pipeline finished. Final state: {}", (Object)stateInfo.state);
        return stateInfo.state;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(null);
    }

    public @UnknownKeyFor @NonNull @Initialized MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.executionContext.getMetricsContainer().getContainers());
    }

    private @UnknownKeyFor @NonNull @Initialized StateInfo getStateInfo() {
        ApplicationStatus status = this.runner.status();
        switch (status.getStatusCode()) {
            case New: {
                return new StateInfo(PipelineResult.State.STOPPED);
            }
            case Running: {
                return new StateInfo(PipelineResult.State.RUNNING);
            }
            case SuccessfulFinish: {
                return new StateInfo(PipelineResult.State.DONE);
            }
            case UnsuccessfulFinish: {
                LOG.error(status.getThrowable().getMessage(), status.getThrowable());
                return new StateInfo(PipelineResult.State.FAILED, new Pipeline.PipelineExecutionException(SamzaPipelineResult.getUserCodeException(status.getThrowable())));
            }
        }
        return new StateInfo(PipelineResult.State.UNKNOWN);
    }

    private static @UnknownKeyFor @NonNull @Initialized Throwable getUserCodeException(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!(t instanceof UserCodeException)) continue;
            return t;
        }
        return throwable;
    }

    private static class StateInfo {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PipelineResult.State state;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineExecutionException error;

        private StateInfo(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PipelineResult.State state) {
            this(state, (Pipeline.PipelineExecutionException)null);
        }

        private StateInfo(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PipelineResult.State state, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineExecutionException error) {
            this.state = state;
            this.error = error;
        }
    }
}

