/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.metrics;

import java.io.Closeable;
import org.apache.beam.runners.samza.metrics.SamzaMetricsContainer;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;

public class FnWithMetricsWrapper {
    private final SamzaMetricsContainer metricsContainer;
    private final String stepName;

    public FnWithMetricsWrapper(SamzaMetricsContainer metricsContainer, String stepName) {
        this.metricsContainer = metricsContainer;
        this.stepName = stepName;
    }

    public <T> T wrap(SupplierWithException<T> fn, boolean shouldUpdateMetrics) throws Exception {
        try (Closeable closeable = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer.getContainer(this.stepName));){
            T result = fn.get();
            if (shouldUpdateMetrics) {
                this.metricsContainer.updateMetrics(this.stepName);
            }
            T t = result;
            return t;
        }
    }

    public static interface SupplierWithException<T> {
        public T get() throws Exception;
    }
}

