/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.core.serialization.Base64Serializer;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.SamzaTestStreamSystemFactory;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.samza.SamzaException;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.GenericInputDescriptor;
import org.apache.samza.system.descriptors.GenericSystemDescriptor;

public class SamzaTestStreamTranslator<T>
implements TransformTranslator<TestStream<T>> {
    @Override
    public void translate(TestStream<T> testStream, TransformHierarchy.Node node, TranslationContext ctx) {
        String encodedTestStream;
        PCollection output = (PCollection)ctx.getOutput(testStream);
        String outputId = ctx.getIdForPValue((PValue)output);
        Coder valueCoder = testStream.getValueCoder();
        TestStream.TestStreamCoder testStreamCoder = TestStream.TestStreamCoder.of((Coder)valueCoder);
        GenericSystemDescriptor systemDescriptor = new GenericSystemDescriptor(outputId, SamzaTestStreamSystemFactory.class.getName());
        try {
            encodedTestStream = CoderUtils.encodeToBase64((Coder)testStreamCoder, testStream);
        }
        catch (CoderException e) {
            throw new SamzaException("Could not encode TestStream.", (Throwable)e);
        }
        SerializableFunction & Serializable testStreamDecoder = (SerializableFunction & Serializable)string -> {
            try {
                return (TestStream)CoderUtils.decodeFromBase64((Coder)TestStream.TestStreamCoder.of((Coder)valueCoder), (String)string);
            }
            catch (CoderException e) {
                throw new SamzaException("Could not decode TestStream.", (Throwable)e);
            }
        };
        ImmutableMap systemConfig = ImmutableMap.of((Object)"encodedTestStream", (Object)encodedTestStream, (Object)"testStreamDecoder", (Object)Base64Serializer.serializeUnchecked((Serializable)testStreamDecoder));
        systemDescriptor.withSystemConfigs((Map)systemConfig);
        KVSerde kvSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
        GenericInputDescriptor inputDescriptor = systemDescriptor.getInputDescriptor(outputId, (Serde)kvSerde);
        ctx.registerInputMessageStream((PValue)output, inputDescriptor);
    }

    @Override
    public void translatePortable(PipelineNode.PTransformNode transform, QueryablePipeline pipeline, PortableTranslationContext ctx) {
        throw new SamzaException("TestStream is not supported in portable by Samza runner");
    }
}

