/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.samza.Partition;
import org.apache.samza.config.Config;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;

public class SamzaImpulseSystemFactory
implements SystemFactory {
    private static final String DUMMY_OFFSET = "0";

    public SystemConsumer getConsumer(String systemName, Config config, MetricsRegistry metricsRegistry) {
        return new SamzaImpulseSystemConsumer();
    }

    public SystemProducer getProducer(String systemName, Config config, MetricsRegistry metricsRegistry) {
        throw new UnsupportedOperationException("SamzaImpulseSystem doesn't support producing");
    }

    public SystemAdmin getAdmin(String systemName, Config config) {
        return new SamzaImpulseSystemAdmin();
    }

    public static class SamzaImpulseSystemConsumer
    implements SystemConsumer {
        private AtomicBoolean isEnd = new AtomicBoolean(false);

        public void start() {
        }

        public void stop() {
        }

        public void register(SystemStreamPartition ssp, String offset) {
        }

        private static List<IncomingMessageEnvelope> constructMessages(SystemStreamPartition ssp) {
            IncomingMessageEnvelope impulseMessage = new IncomingMessageEnvelope(ssp, SamzaImpulseSystemFactory.DUMMY_OFFSET, null, OpMessage.ofElement(WindowedValue.valueInGlobalWindow((Object)new byte[0])));
            IncomingMessageEnvelope watermarkMessage = IncomingMessageEnvelope.buildWatermarkEnvelope((SystemStreamPartition)ssp, (long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis());
            IncomingMessageEnvelope endOfStreamMessage = IncomingMessageEnvelope.buildEndOfStreamEnvelope((SystemStreamPartition)ssp);
            return Arrays.asList(impulseMessage, watermarkMessage, endOfStreamMessage);
        }

        public Map<SystemStreamPartition, List<IncomingMessageEnvelope>> poll(Set<SystemStreamPartition> ssps, long timeout) throws InterruptedException {
            if (this.isEnd.compareAndSet(false, true)) {
                return ssps.stream().collect(Collectors.toMap(Function.identity(), SamzaImpulseSystemConsumer::constructMessages));
            }
            return Collections.emptyMap();
        }
    }

    public static class SamzaImpulseSystemAdmin
    implements SystemAdmin {
        public Map<SystemStreamPartition, String> getOffsetsAfter(Map<SystemStreamPartition, String> offset) {
            return offset.keySet().stream().collect(Collectors.toMap(Function.identity(), k -> SamzaImpulseSystemFactory.DUMMY_OFFSET));
        }

        public Map<String, SystemStreamMetadata> getSystemStreamMetadata(Set<String> streamNames) {
            return streamNames.stream().collect(Collectors.toMap(Function.identity(), stream -> {
                Map<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> partitionMetadata = Collections.singletonMap(new Partition(0), new SystemStreamMetadata.SystemStreamPartitionMetadata(SamzaImpulseSystemFactory.DUMMY_OFFSET, SamzaImpulseSystemFactory.DUMMY_OFFSET, SamzaImpulseSystemFactory.DUMMY_OFFSET));
                return new SystemStreamMetadata(stream, partitionMetadata);
            }));
        }

        public Integer offsetComparator(String offset1, String offset2) {
            return 0;
        }
    }
}

