/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.util.HashIdGenerator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.table.Table;
import org.apache.samza.table.descriptors.TableDescriptor;

public class PortableTranslationContext {
    private final Map<String, MessageStream<?>> messsageStreams = new HashMap();
    private final StreamApplicationDescriptor appDescriptor;
    private final JobInfo jobInfo;
    private final SamzaPipelineOptions options;
    private final Set<String> registeredInputStreams = new HashSet<String>();
    private final Map<String, Table> registeredTables = new HashMap<String, Table>();
    private final HashIdGenerator idGenerator = new HashIdGenerator();
    private PipelineNode.PTransformNode currentTransform;

    public PortableTranslationContext(StreamApplicationDescriptor appDescriptor, SamzaPipelineOptions options, JobInfo jobInfo) {
        this.jobInfo = jobInfo;
        this.appDescriptor = appDescriptor;
        this.options = options;
    }

    public SamzaPipelineOptions getSamzaPipelineOptions() {
        return this.options;
    }

    public <T> List<MessageStream<OpMessage<T>>> getAllInputMessageStreams(PipelineNode.PTransformNode transform) {
        Collection inputStreamIds = transform.getTransform().getInputsMap().values();
        return inputStreamIds.stream().map(this::getMessageStreamById).collect(Collectors.toList());
    }

    public <T> MessageStream<OpMessage<T>> getOneInputMessageStream(PipelineNode.PTransformNode transform) {
        String id = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        return this.getMessageStreamById(id);
    }

    public <T> MessageStream<OpMessage<T>> getMessageStreamById(String id) {
        return this.messsageStreams.get(id);
    }

    public String getInputId(PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
    }

    public String getOutputId(PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values());
    }

    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public <T> void registerMessageStream(String id, MessageStream<OpMessage<T>> stream) {
        if (this.messsageStreams.containsKey(id)) {
            throw new IllegalArgumentException("Stream already registered for id: " + id);
        }
        this.messsageStreams.put(id, stream);
    }

    public <OutT> OutputStream<OutT> getOutputStream(OutputDescriptor<OutT, ?> outputDescriptor) {
        return this.appDescriptor.getOutputStream(outputDescriptor);
    }

    public <T> void registerInputMessageStream(String id, InputDescriptor<KV<?, OpMessage<T>>, ?> inputDescriptor) {
        String streamId = inputDescriptor.getStreamId();
        if (this.registeredInputStreams.contains(streamId)) {
            return;
        }
        MessageStream stream = this.appDescriptor.getInputStream(inputDescriptor).map(KV::getValue);
        this.registerMessageStream(id, stream);
        this.registeredInputStreams.add(streamId);
    }

    public WindowedValue.WindowedValueCoder instantiateCoder(String collectionId, RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
        try {
            return (WindowedValue.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder((PipelineNode.PCollectionNode)collectionNode, (RunnerApi.Components)components);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WindowingStrategy<?, BoundedWindow> getPortableWindowStrategy(String collectionId, RunnerApi.Components components) {
        WindowingStrategy windowingStrategy;
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)components);
        RunnerApi.WindowingStrategy windowingStrategyProto = components.getWindowingStrategiesOrThrow(components.getPcollectionsOrThrow(collectionId).getWindowingStrategyId());
        try {
            windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)rehydratedComponents);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to hydrate GroupByKey windowing strategy %s.", windowingStrategyProto), e);
        }
        WindowingStrategy ret = windowingStrategy;
        return ret;
    }

    public <K, V> Table<KV<K, V>> getTable(TableDescriptor<K, V, ?> tableDesc) {
        return this.registeredTables.computeIfAbsent(tableDesc.getTableId(), id -> this.appDescriptor.getTable(tableDesc));
    }

    public void setCurrentTransform(PipelineNode.PTransformNode currentTransform) {
        this.currentTransform = currentTransform;
    }

    public void clearCurrentTransform() {
        this.currentTransform = null;
    }

    public String getTransformFullName() {
        return this.currentTransform.getTransform().getUniqueName();
    }

    public String getTransformId() {
        return this.idGenerator.getId(this.currentTransform.getTransform().getUniqueName());
    }
}

