/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.util.Collection;
import org.apache.beam.runners.samza.runtime.Op;
import org.apache.beam.runners.samza.runtime.OpEmitter;
import org.apache.beam.runners.samza.runtime.SamzaAssignContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

public class WindowAssignOp<T, W extends BoundedWindow>
implements Op<T, T, Void> {
    private final WindowFn<T, W> windowFn;

    public WindowAssignOp(WindowFn<T, W> windowFn) {
        this.windowFn = windowFn;
    }

    @Override
    public void processElement(WindowedValue<T> inputElement, OpEmitter<T> emitter) {
        Collection windows;
        try {
            windows = this.windowFn.assignWindows(new SamzaAssignContext<T, W>(this.windowFn, inputElement));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        windows.stream().map(window -> WindowedValue.of((Object)inputElement.getValue(), (Instant)inputElement.getTimestamp(), (BoundedWindow)window, (PaneInfo)inputElement.getPane())).forEach(outputElement -> emitter.emitElement((WindowedValue)outputElement));
    }
}

